/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.template;

import gov.va.med.hds.hdr.transformer.template.InstanceData;
import gov.va.med.hds.hdr.transformer.template.TemplateBuilderDelegate;
import gov.va.med.hds.hdr.transformer.template.TemplateBuildingException;

public class TemplateBuilderHelper {
    private TemplateBuilderDelegate templateBuilderDelegate = null;

    public TemplateBuilderHelper(TemplateBuilderDelegate templateBuilderDelegate) {
        this.templateBuilderDelegate = templateBuilderDelegate;
    }

    private Object buildAttribute(String name, String type) {
        return this.templateBuilderDelegate.createAttribute(name, type);
    }

    private boolean isLeafNode(String path) {
        return path.indexOf(46) == -1;
    }

    private String getNextInstanceFromPath(String path) {
        return path.substring(0, path.indexOf(")") + 1);
    }

    private String getRemainderPath(String path) {
        return path.substring(path.indexOf(41) + 2);
    }

    public Object getInstance(Object parent, String path, boolean createInstance) throws TemplateBuildingException {
        Object instance = null;
        Object nextNode = null;
        String rawInstanceData = this.getNextInstanceFromPath(path);
        String pathRemainder = this.getRemainderPath(path);
        InstanceData instanceData = new InstanceData(rawInstanceData);
        if (this.isLeafNode(pathRemainder) && createInstance) {
            nextNode = this.templateBuilderDelegate.createInstance(instanceData);
            this.templateBuilderDelegate.addContent(parent, instanceData.getRole(), nextNode);
        } else {
            nextNode = this.templateBuilderDelegate.getInstanceHavingTypeAndRole(parent, instanceData);
            if (nextNode == null) {
                nextNode = this.templateBuilderDelegate.createInstance(instanceData);
                this.templateBuilderDelegate.addContent(parent, instanceData.getRole(), nextNode);
            }
        }
        instance = this.getInstance(nextNode, pathRemainder, createInstance);
        return instance;
    }

    public Object getAttribute(Object parent, String path, String type, boolean createInstance, boolean createAttribute) throws TemplateBuildingException {
        Object attribute = null;
        if (this.isLeafNode(path)) {
            if (createAttribute) {
                attribute = this.buildAttribute(path, type);
                this.templateBuilderDelegate.addContent(parent, path, attribute);
            } else {
                attribute = this.templateBuilderDelegate.getAttributeHavingNameAndType(parent, path, type);
                if (attribute == null) {
                    attribute = this.templateBuilderDelegate.createAttribute(path, type);
                    this.templateBuilderDelegate.addContent(parent, path, attribute);
                }
            }
        } else {
            Object nextNode = null;
            String rawInstanceData = this.getNextInstanceFromPath(path);
            String pathRemainder = this.getRemainderPath(path);
            InstanceData instanceData = new InstanceData(rawInstanceData);
            if (this.isLeafNode(pathRemainder) && createInstance) {
                nextNode = this.templateBuilderDelegate.createInstance(instanceData);
                this.templateBuilderDelegate.addContent(parent, instanceData.getRole(), nextNode);
            } else {
                nextNode = this.templateBuilderDelegate.getInstanceHavingTypeAndRole(parent, instanceData);
                if (nextNode == null) {
                    nextNode = this.templateBuilderDelegate.createInstance(instanceData);
                    this.templateBuilderDelegate.addContent(parent, instanceData.getRole(), nextNode);
                }
            }
            attribute = this.getAttribute(nextNode, pathRemainder, type, createInstance, createAttribute);
        }
        return attribute;
    }

    public void setFieldText(Object attribute, String name, String text, boolean append, char separator) {
        this.setFieldText(attribute, name, null, text, append, separator);
    }

    public void setFieldText(Object attribute, String name, String sourceType, String text, boolean append, char separator) {
        Object field = this.templateBuilderDelegate.getFieldHavingName(attribute, name);
        if (field == null) {
            field = this.templateBuilderDelegate.createField(name, "java.lang.String");
            this.templateBuilderDelegate.addContent(attribute, name, field);
        }
        if (append) {
            this.templateBuilderDelegate.appendFieldValue(attribute, field, text, separator);
        } else {
            this.templateBuilderDelegate.setFieldValue(attribute, field, text);
        }
    }
}

