/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.template;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.transformer.template.InstanceData;
import gov.va.med.hds.hdr.transformer.template.TemplateBuilderDelegate;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.List;

public class ReflectionObjectBuilderDelegate
implements TemplateBuilderDelegate {
    public void addContent(Object parent, String name, Object content) {
        try {
            Method setter = this.findSetterMethod(parent, name, new Class[]{content.getClass()});
            if (setter != null) {
                setter.invoke(parent, content);
            }
        }
        catch (Exception e) {
            throw IMSException.getIMSException("An error occurred while adding content.", e);
        }
    }

    public void appendFieldValue(Object parent, Object field, String value, char separator) {
        try {
            if (!(field instanceof Field)) {
                throw new IllegalArgumentException("appendFieldValue: Invalid field.");
            }
            Field f = (Field)field;
            Method getter = this.findGetterMethod(parent, f.getName(), new Class[0]);
            Method setter = this.findSetterMethod(parent, f.getName(), new Class[]{String.class});
            if (setter == null) {
                throw new IllegalArgumentException("appendFieldValue: Not setter defined for field.");
            }
            if (getter == null) {
                throw new IllegalArgumentException("appendFieldValue: Not getter defined for field.");
            }
            String s = (String)getter.invoke(parent, new Object[0]);
            if (s == null || s.length() == 0) {
                setter.invoke(parent, value);
            } else {
                setter.invoke(parent, s + separator + value);
            }
        }
        catch (Exception e) {
            throw IMSException.getIMSException("Error appending value to field.", e);
        }
    }

    public void setFieldValue(Object parent, Object field, String value) {
        try {
            if (!(field instanceof Field)) {
                throw new IllegalArgumentException("setFieldValue:Invalid field.");
            }
            Field f = (Field)field;
            Method setter = this.findSetterMethod(parent, f.getName(), new Class[]{String.class});
            if (setter == null) {
                throw new IllegalArgumentException("The field provided is not valid.");
            }
            setter.invoke(parent, value);
        }
        catch (Exception e) {
            throw IMSException.getIMSException("setFieldValue:Invalid field.", e);
        }
    }

    public Object createAttribute(String name, String type) {
        try {
            return Class.forName(type).newInstance();
        }
        catch (Exception e) {
            throw IMSException.getIMSException();
        }
    }

    public Object createField(String name, String type) {
        return null;
    }

    public Object createInstance(InstanceData instanceData) {
        try {
            return Class.forName(instanceData.getType()).newInstance();
        }
        catch (Exception e) {
            throw IMSException.getIMSException("An error occurred while creating the instance of type '" + instanceData.getType() + "'.", e);
        }
    }

    public Object getAttributeHavingNameAndType(Object parent, String name, String type) {
        try {
            if ("this".equals(name) && parent.getClass().getName().equals(type)) {
                return parent;
            }
            return this.getNamedProperty(parent, name);
        }
        catch (Exception e) {
            throw IMSException.getIMSException("Error getting instance having name" + name + ").", e);
        }
    }

    public Object getFieldHavingName(Object parent, String name) {
        try {
            Field f = this.getNamedField(parent.getClass(), name);
            f.setAccessible(true);
            return f;
        }
        catch (Exception e) {
            throw IMSException.getIMSException("Error getting instance having name(" + name + ").", e);
        }
    }

    public Object getInstanceHavingTypeAndRole(Object parent, InstanceData instanceData) {
        try {
            if (parent instanceof Collection) {
                return this.getListProperty((Collection)parent, Class.forName(instanceData.getType()));
            }
            return this.getNamedProperty(parent, instanceData.getRole());
        }
        catch (Exception e) {
            throw IMSException.getIMSException("Error getting instance having type(" + instanceData.getType() + ") and role(" + instanceData.getRole() + ").", e);
        }
    }

    private Object getPropertyFromList(List parent, String name) throws Exception {
        Object property = null;
        if (parent != null && parent.size() > 0) {
            property = parent.get(parent.size() - 1);
        }
        return property;
    }

    private Object getNamedProperty(Object parent, String name) throws Exception {
        Object obj = null;
        Field f = this.getNamedField(parent.getClass(), name);
        f.setAccessible(true);
        obj = f.get(parent);
        if (obj instanceof Collection) {
            Collection c = (Collection)obj;
            int size = c.size();
            Object[] arr = c.toArray();
            obj = arr[size - 1];
        }
        return obj;
    }

    private Object getListProperty(Collection parent, Class type) {
        Object[] arr;
        Object obj = null;
        int size = parent.size();
        if (size != 0 && type.isInstance((arr = parent.toArray())[size - 1])) {
            obj = arr[size - 1];
        }
        return obj;
    }

    private Method findSetterMethod(Object parent, String propertyName, Class[] parameterTypes) {
        Method m = null;
        Class<?> c = parent.getClass();
        propertyName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            m = this.getNamedMethod(c, "set" + propertyName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            try {
                m = this.getNamedMethod(c, "add" + propertyName, parameterTypes);
            }
            catch (NoSuchMethodException e1) {
                try {
                    m = this.getNamedMethod(c, "add" + propertyName.substring(0, propertyName.length() - 1), parameterTypes);
                }
                catch (NoSuchMethodException e2) {
                    try {
                        m = this.getNamedMethod(c, "add", new Class[]{Object.class});
                    }
                    catch (NoSuchMethodException e3) {
                        throw IMSException.getIMSException("Error finding setter method with base of '" + propertyName + "'", new NoSuchMethodException());
                    }
                }
            }
        }
        return m;
    }

    private Method findGetterMethod(Object parent, String propertyName, Class[] parameterTypes) {
        Method m = null;
        Class<?> c = parent.getClass();
        propertyName = propertyName.substring(0, 1).toUpperCase() + propertyName.substring(1);
        try {
            m = this.getNamedMethod(c, "get" + propertyName, parameterTypes);
        }
        catch (NoSuchMethodException e) {
            throw IMSException.getIMSException("Error finding setter method with base of '" + propertyName + "'", new NoSuchMethodException());
        }
        return m;
    }

    private Field getNamedField(Class c, String name) throws NoSuchFieldException {
        try {
            return c.getDeclaredField(name);
        }
        catch (NoSuchFieldException e) {
            Class sc = c.getSuperclass();
            if (sc != null) {
                return this.getNamedField(sc, name);
            }
            throw e;
        }
    }

    private Method getNamedMethod(Class c, String name, Class[] params) throws NoSuchMethodException {
        try {
            return c.getDeclaredMethod(name, params);
        }
        catch (NoSuchMethodException e) {
            Class sc = c.getSuperclass();
            if (sc != null) {
                return this.getNamedMethod(sc, name, params);
            }
            throw e;
        }
    }
}

