/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.service;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.service.ServiceFactory;
import gov.va.med.hds.hdr.service.ServiceRegistry;
import gov.va.med.hds.hdr.service.ServiceUnavailableException;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyMgrServiceRegistry
implements ServiceRegistry {
    private static final String XP_SERVICE = "ServiceRegistry/service[@name='NAME']/@factory";
    private static final String XP_PROPERTIES = "ServiceRegistry/service[@name='NAME']/property";
    private static final PropertyMgrServiceRegistry INSTANCE = new PropertyMgrServiceRegistry();
    private static PropertyMgr pm = PropertyMgr.getInstance();
    private Map<String, Object> serviceMap = new Hashtable<String, Object>();

    private PropertyMgrServiceRegistry() {
    }

    public static ServiceRegistry getInstance() {
        return INSTANCE;
    }

    public static ServiceRegistry getInstance(Map<String, Object> serviceMap) {
        PropertyMgrServiceRegistry.INSTANCE.serviceMap.putAll(serviceMap);
        return PropertyMgrServiceRegistry.getInstance();
    }

    @Override
    public Object find(String key) throws ServiceUnavailableException {
        Object service = this.serviceMap.get(key);
        if (service == null) {
            try {
                ServiceFactory factory = (ServiceFactory)Class.forName(pm.getProperty(XP_SERVICE.replaceFirst("NAME", key)).getValue()).newInstance();
                Properties properties = new Properties();
                PropertyElement[] props = pm.getProperties(XP_PROPERTIES.replaceFirst("NAME", key));
                for (int i = 0; i < props.length; ++i) {
                    String value = props[i].getAttribute("value");
                    properties.put(props[i].getAttribute("name"), null == value || 0 == value.length() ? props[i].getChildProperties() : value);
                }
                service = factory.createService(properties);
                this.serviceMap.put(key, service);
            }
            catch (Exception e) {
                throw new ServiceUnavailableException("An error was encountered while creating the service object.", e);
            }
        }
        return service;
    }
}

