/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.msgloader.oracle;

import gov.va.med.hds.hdr.transformer.jms.QueueLocator;
import gov.va.med.hds.hdr.transformer.msgloader.oracle.jpub.HL7MessageCustomDatumFactory;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.NamingException;
import oracle.AQ.AQException;
import oracle.AQ.AQQueueTable;
import oracle.jms.AQjmsConnection;
import oracle.jms.AQjmsFactory;
import oracle.jms.AQjmsQueueReceiver;
import oracle.jms.AQjmsSession;

public class OracleQueueLocator
implements QueueLocator {
    private static final String HOST = "host";
    private static final String SID = "sid";
    private static final String PORT = "port";
    private static final String DRIVER = "driver";
    private static final String QUEUE_USER = "queueUser";
    private static final String QUEUE_PASSWORD = "queuePassword";
    private static final String QUEUE_OWNER = "queueOwner";
    private static final String QUEUE_NAME = "queueName";
    private static final String HDR_CUSTOM_PAYLOAD = "IMS_HL7_MESSAGE_TYPE";
    private Properties env = null;
    private volatile AQjmsConnection connection = null;

    public OracleQueueLocator(Properties env) {
        this.env = env;
    }

    public Queue getQueue(Session session) throws JMSException {
        AQjmsSession aqSession = (AQjmsSession)session;
        return aqSession.getQueue(this.env.getProperty(QUEUE_OWNER), this.env.getProperty(QUEUE_NAME));
    }

    private QueueConnectionFactory getQueueConectionFactory(Properties env) throws JMSException {
        String host = env.getProperty(HOST);
        String sid = env.getProperty(SID);
        int port = Integer.parseInt(env.getProperty(PORT));
        String driver = env.getProperty(DRIVER);
        return AQjmsFactory.getQueueConnectionFactory((String)host, (String)sid, (int)port, (String)driver);
    }

    public QueueReceiver getReciever(QueueSession session, Queue queue) throws JMSException {
        AQjmsSession aqSession = (AQjmsSession)session;
        AQQueueTable qTable = aqSession.getQueueTable(this.env.getProperty(QUEUE_OWNER), this.tableFromQueue(queue));
        String payloadType = HDR_CUSTOM_PAYLOAD;
        try {
            payloadType = qTable.getProperty().getPayloadType();
        }
        catch (AQException e) {
            // empty catch block
        }
        AQjmsQueueReceiver receiver = payloadType.endsWith(HDR_CUSTOM_PAYLOAD) ? (AQjmsQueueReceiver)aqSession.createReceiver(queue, (Object)HL7MessageCustomDatumFactory.getInstance()) : (AQjmsQueueReceiver)aqSession.createReceiver(queue);
        receiver.setNavigationMode(3);
        return receiver;
    }

    public QueueSender getSender(QueueSession session, Queue queue) throws JMSException {
        QueueSender sender = session.createSender(queue);
        sender.setDeliveryMode(2);
        return sender;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueConnection getConnection() throws JMSException, NamingException {
        if (this.connection == null) {
            OracleQueueLocator oracleQueueLocator = this;
            synchronized (oracleQueueLocator) {
                if (this.connection == null) {
                    QueueConnectionFactory factory = this.getQueueConectionFactory(this.env);
                    String queueUser = this.env.getProperty(QUEUE_USER);
                    String queuePassword = this.env.getProperty(QUEUE_PASSWORD);
                    this.connection = (AQjmsConnection)factory.createQueueConnection(queueUser, queuePassword);
                }
            }
        }
        return this.connection;
    }

    private String tableFromQueue(Queue queue) {
        String queueTable = "";
        try {
            queueTable = queue.getQueueName() + "_TAB";
        }
        catch (JMSException e) {
            e.printStackTrace();
        }
        return queueTable;
    }
}

