/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.msgloader.oracle;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.transformer.jms.QueueLocator;
import gov.va.med.hds.hdr.transformer.msgloader.BaseMessageListener;
import gov.va.med.hds.hdr.transformer.msgloader.MessageLoaderException;
import gov.va.med.hds.hdr.transformer.msgloader.MessageReader;
import gov.va.med.hds.hdr.transformer.msgloader.oracle.jpub.HL7Message;
import javax.jms.Message;
import oracle.jms.AdtMessage;
import oracle.sql.CLOB;

public class OracleHL7TypedMessageListener
extends BaseMessageListener {
    public OracleHL7TypedMessageListener(String domain, QueueLocator locator, MessageReader reader) throws MessageLoaderException {
        super(domain, locator, reader);
    }

    public void onMessage(Message message) {
        Thread thisThread = Thread.currentThread();
        this.incrementMsgsDQd();
        long startTime = System.currentTimeMillis();
        this.setGlobalLastTime(startTime);
        try {
            AdtMessage adtMessage = (AdtMessage)message;
            HL7Message hl7Message = (HL7Message)adtMessage.getAdtPayload();
            CLOB clob = hl7Message.getHl7Message();
            int jmsRetryCt = message.getIntProperty("JMSXDeliveryCount");
            this.reader.processMessage(this.getDomain(), clob.getCharacterStream());
            this.incrementSuccessful();
        }
        catch (Exception e) {
            this.incrementFailed();
            e.printStackTrace();
            throw IMSException.getIMSException(e, null, null, ErrorCode.UNCL_003, new String[]{e.getMessage()});
        }
        finally {
            this.accumulateElapse(System.currentTimeMillis() - startTime);
        }
    }
}

