/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.msgloader.jndi;

import gov.va.med.hds.hdr.transformer.jms.QueueLocator;
import java.util.Hashtable;
import java.util.Properties;
import javax.jms.JMSException;
import javax.jms.Queue;
import javax.jms.QueueConnection;
import javax.jms.QueueConnectionFactory;
import javax.jms.QueueReceiver;
import javax.jms.QueueSender;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NamingException;

public class JNDIQueueLocator
implements QueueLocator {
    private static final String BROKER = "broker";
    private static final String USER = "user";
    private static final String PASSWORD = "password";
    private static final String CONTEXT_FACTORY = "contextFactory";
    private static final String CONN_FACTORY_NAME = "connectionFactoryName";
    private static final String QUEUE_USER = "queueUser";
    private static final String QUEUE_PASSWORD = "queuePassword";
    private static final String QUEUE_NAME = "queueName";
    private Properties env = null;
    private Context context = null;
    private QueueConnectionFactory queueConnectionFactory = null;
    private QueueConnection connection = null;

    public JNDIQueueLocator(Properties env) {
        this.env = env;
    }

    public QueueConnection getConnection() throws JMSException, NamingException {
        if (this.connection == null) {
            this.queueConnectionFactory = this.getQueueConectionFactory();
            this.connection = this.queueConnectionFactory.createQueueConnection(this.env.getProperty(QUEUE_USER), this.env.getProperty(QUEUE_PASSWORD));
        }
        return this.connection;
    }

    private QueueConnectionFactory getQueueConectionFactory() throws JMSException, NamingException {
        Hashtable<String, String> properties = new Hashtable<String, String>();
        properties.put("java.naming.factory.initial", this.env.getProperty(CONTEXT_FACTORY));
        properties.put("java.naming.provider.url", this.env.getProperty(BROKER));
        properties.put("java.naming.security.principal", this.env.getProperty(USER));
        properties.put("java.naming.security.credentials", this.env.getProperty(PASSWORD));
        this.context = new InitialContext(properties);
        return (QueueConnectionFactory)this.context.lookup(this.env.getProperty(CONN_FACTORY_NAME));
    }

    public Queue getQueue(Session session) throws JMSException, NamingException {
        return (Queue)this.context.lookup(this.env.getProperty(QUEUE_NAME));
    }

    public QueueReceiver getReciever(QueueSession session, Queue queue) throws JMSException {
        return session.createReceiver(queue);
    }

    public QueueSender getSender(QueueSession session, Queue queue) throws JMSException {
        return session.createSender(queue);
    }
}

