/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.msgloader.hl7;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.transformer.commonadapters.messageprocessor.MessageProcessor;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.hl7.ApplicationAcknowledgmentResponse;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.hl7.HL7Service;
import gov.va.med.hds.hdr.transformer.hl7.parser.HL7Validator;
import gov.va.med.hds.hdr.transformer.hl7.parser.HL7ValidatorFactory;
import gov.va.med.hds.hdr.transformer.msgloader.DefaultMessageReader;
import java.util.Map;

public class HL7MessageReader
extends DefaultMessageReader {
    private boolean doValidation;
    private Map validators;
    private static final HL7Service hl7Service = ServiceLocator.getInstance().getHL7Service();
    private final ApplicationAcknowledgmentResponse appAckHandler = hl7Service.getApplicationAcknowledgeResponseObject();

    public HL7MessageReader(MessageProcessor processor) {
        super(processor);
        try {
            this.validators = HL7ValidatorFactory.getHL7Validators();
            this.doValidation = !this.validators.isEmpty();
        }
        catch (Exception e) {
            IMSException.getIMSException(e, (CharSequence)"Unable to load HL7Validator", null, ErrorCode.UNCL_000, new String[]{"Unable to load HL7Validator"});
            this.doValidation = false;
        }
    }

    protected boolean isValid(StringBuffer rawMessage) {
        HL7Validator validator;
        boolean valid = true;
        if (this.doValidation && (validator = (HL7Validator)this.validators.get(HL7Validator.getHL7MessageType(rawMessage))) != null) {
            valid = validator.valid(rawMessage.toString());
        }
        return valid;
    }

    protected void doAcknowledgement(boolean success, String error, StringBuffer rawMessage, String domain) {
        if (null != this.appAckHandler) {
            try {
                this.appAckHandler.sendApplicationAck(rawMessage.toString(), success, domain, error);
            }
            catch (Exception e) {
                IMSException.getIMSException(e, (CharSequence)"Application ACK exception", "HL7MessageReader:doAcknowledgement", ErrorCode.HL7M_011, new String[]{rawMessage.toString()});
            }
        }
    }
}

