/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.msgloader;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.commonadapters.messageprocessor.MessageProcessor;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.fhie.transformer.systemcontrol.ApplicationCtrlEvent;
import gov.fhie.transformer.systemcontrol.ApplicationCtrlListener;
import gov.va.med.hds.hdr.common.thread.Synchronizer;
import gov.va.med.hds.hdr.common.util.MBeanRegistrar;
import gov.va.med.hds.hdr.transformer.jms.QueueLocator;
import gov.va.med.hds.hdr.transformer.jms.QueueLocatorFactory;
import gov.va.med.hds.hdr.transformer.msgloader.BaseMessageListener;
import gov.va.med.hds.hdr.transformer.msgloader.JMSMessageLoaderMBean;
import gov.va.med.hds.hdr.transformer.msgloader.MessageLoaderException;
import gov.va.med.hds.hdr.transformer.msgloader.MessageReader;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import javax.jms.ExceptionListener;
import javax.jms.JMSException;
import javax.jms.MessageListener;
import javax.jms.QueueConnection;
import javax.management.Notification;
import javax.management.NotificationListener;

public class JMSMessageLoader
implements ApplicationCtrlListener,
ExceptionListener,
JMSMessageLoaderMBean,
NotificationListener {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_COUNT = "count";
    private static final String XP_QUEUELISTENER = "messageloader[@name='NAME']/queueListener";
    private static final String XP_QUEUELOCATOR = "messageloader[@name='NAME']/queueLocator";
    private static final String XP_PROCESSOR_CHILDREN = "messageloader[@name='NAME']/processor/*";
    private static final String XP_PROCESSOR = "messageloader[@name='NAME']/processor/@class";
    private static final String XP_PROCESSOR_AUDIT = "messageloader[@name='NAME']/processor/@audit";
    private static final String XP_MESSAGEREADER = "messageloader[@name='NAME']/messagereader/@class";
    private static final String XP_SYNC_KEY = "messageloader[@name='NAME']/@sync-key";
    private static final Map<String, Synchronizer> SYNCHRONIZERS = new Hashtable<String, Synchronizer>();
    private String serviceName = null;
    private String domain = null;
    private PropertyMgr propertyMgr = null;
    private QueueConnection connection = null;
    private QueueLocator queueLocator = null;
    private List<MessageListener> messageListeners = new ArrayList<MessageListener>();

    public JMSMessageLoader(String domain, String serviceName) throws MessageLoaderException {
        if (domain == null || "".equals(domain)) {
            throw new MessageLoaderException("The domain string passed in cannot be null or zero-length.");
        }
        if (serviceName == null || "".equals(serviceName)) {
            throw new MessageLoaderException("The service name passed in cannot be null or zero-length.");
        }
        this.propertyMgr = PropertyMgr.getInstance(domain);
        this.domain = domain;
        this.serviceName = serviceName;
        MBeanRegistrar.registerMBean(serviceName, (Object)this);
    }

    private void initializeJMSSubSystem() throws MessageLoaderException {
        try {
            PropertyElement queueLocatorElement = this.propertyMgr.getProperty(XP_QUEUELOCATOR.replaceFirst("NAME", this.serviceName));
            this.queueLocator = QueueLocatorFactory.createInstance(queueLocatorElement);
            this.connection = this.queueLocator.getConnection();
            this.initQueueListeners();
            this.connection.setExceptionListener((ExceptionListener)this);
            this.connection.start();
        }
        catch (Exception e) {
            throw new MessageLoaderException("JMS message loader encountered an exception while initializing the JMS sub-system.", e);
        }
    }

    public final void startFileLoading(ApplicationCtrlEvent event) {
        try {
            this.initializeJMSSubSystem();
        }
        catch (MessageLoaderException e) {
            IMSException.getIMSException(e, (CharSequence)"Unable to initialize JMS subsystem", null, ErrorCode.JMS_013, new String[]{e.getMessage()});
        }
    }

    public final void stopFileLoading(ApplicationCtrlEvent e) {
        this.releaseJMSResources();
    }

    public final void shutdown(ApplicationCtrlEvent e) {
        this.releaseJMSResources();
    }

    public void onException(JMSException jmse) {
        boolean reconnected = false;
        IMSException.getIMSException(jmse, null, null, ErrorCode.JMS_015, null);
        this.releaseJMSResources();
        while (!reconnected) {
            try {
                this.initializeJMSSubSystem();
                reconnected = true;
            }
            catch (MessageLoaderException mle) {
                IMSException.getIMSException(jmse, null, null, ErrorCode.JMS_017, null);
                try {
                    Thread.sleep(10000L);
                }
                catch (InterruptedException e) {}
            }
        }
    }

    private void releaseJMSResources() {
        this.shrinkListeners(this.messageListeners.size());
    }

    private final void initQueueListeners() throws Exception {
        int listenerCount = 0;
        listenerCount = Integer.parseInt(this.propertyMgr.getProperty(XP_QUEUELISTENER.replaceFirst("NAME", this.serviceName)).getAttribute(ATTR_COUNT));
        this.growListeners(listenerCount);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public int getListenerCount() {
        return this.messageListeners.size();
    }

    public void setListenerCount(int listenerCount) {
        int diff = this.messageListeners.size() - listenerCount;
        try {
            if (diff < 0) {
                this.growListeners(diff * -1);
            } else if (diff > 0) {
                this.shrinkListeners(diff);
            }
        }
        catch (Exception e) {
            IMSException.getIMSException("Error setting listener count (listener count difference = " + diff + ".", e);
        }
    }

    private void growListeners(int growBy) throws Exception {
        String syncKey = this.propertyMgr.getProperty(XP_SYNC_KEY.replaceFirst("NAME", this.serviceName)).getValue();
        if (syncKey == null || syncKey.length() == 0) {
            throw IMSException.getIMSException("The 'sync-key' attribute of the messageloader[@name='" + this.serviceName + "'] element cannot be null or zero-length");
        }
        Synchronizer synchronizer = SYNCHRONIZERS.get(syncKey);
        if (synchronizer == null) {
            synchronizer = new Synchronizer();
            SYNCHRONIZERS.put(syncKey, synchronizer);
        }
        String className = this.propertyMgr.getProperty(XP_QUEUELISTENER.replaceFirst("NAME", this.serviceName)).getAttribute(ATTR_CLASS);
        Class<?> clazz = Class.forName(className);
        Constructor<?> constructor = clazz.getConstructor(String.class, QueueLocator.class, MessageReader.class);
        String processorClass = this.propertyMgr.getProperty(XP_PROCESSOR.replaceFirst("NAME", this.serviceName)).getValue();
        Boolean isAuditing = new Boolean(this.propertyMgr.getProperty(XP_PROCESSOR_AUDIT.replaceFirst("NAME", this.serviceName)).getValue());
        PropertyElement[] children = this.propertyMgr.getProperties(XP_PROCESSOR_CHILDREN.replaceFirst("NAME", this.serviceName));
        Constructor<?> processor = Class.forName(processorClass).getConstructor(String.class, PropertyElement[].class, Synchronizer.class, Boolean.TYPE);
        String messageReaderClass = this.propertyMgr.getProperty(XP_MESSAGEREADER.replaceFirst("NAME", this.serviceName)).getValue();
        Constructor<?> messageReader = Class.forName(messageReaderClass).getConstructor(MessageProcessor.class);
        if (constructor != null) {
            for (int i = 0; i < growBy; ++i) {
                this.messageListeners.add((MessageListener)constructor.newInstance(this.domain, this.queueLocator, messageReader.newInstance((MessageProcessor)processor.newInstance(this.domain, children, synchronizer, isAuditing))));
            }
        } else {
            throw new Exception("Message Listener constructor with a String parameter not found.");
        }
    }

    private void shrinkListeners(int shrinkBy) {
        for (int i = 0; i < shrinkBy; ++i) {
            BaseMessageListener messageListener = (BaseMessageListener)this.messageListeners.remove(this.messageListeners.size() - 1);
            messageListener.releaseJMSResources();
        }
    }

    public void handleNotification(Notification notification, Object handback) {
    }
}

