/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.msgloader;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.transformer.jms.QueueLocator;
import gov.va.med.hds.hdr.transformer.msgloader.BaseMessageListener;
import gov.va.med.hds.hdr.transformer.msgloader.MessageLoaderException;
import gov.va.med.hds.hdr.transformer.msgloader.MessageReader;
import java.io.StringReader;
import javax.jms.Message;
import javax.jms.TextMessage;

public class HL7TextMessageListener
extends BaseMessageListener {
    public HL7TextMessageListener(String domain, QueueLocator locator, MessageReader reader) throws MessageLoaderException {
        super(domain, locator, reader);
    }

    public void onMessage(Message message) {
        long startTime = System.currentTimeMillis();
        Thread thisThread = Thread.currentThread();
        this.setGlobalLastTime(startTime);
        this.incrementMsgsDQd();
        try {
            String messageText = ((TextMessage)message).getText();
            if (messageText != null && !"".equals(messageText)) {
                int jmsRetryCt = message.getIntProperty("JMSXDeliveryCount");
                this.reader.processMessage(this.getDomain(), new StringReader(messageText));
                this.incrementSuccessful();
            }
        }
        catch (Exception e) {
            this.incrementFailed();
            MessageLoaderException mle = new MessageLoaderException("An error was encountered while processing message from JMS queue.", e);
            throw IMSException.getIMSException(mle, null, null, ErrorCode.UNCL_003, new String[]{mle.getMessage()});
        }
        finally {
            this.accumulateElapse(System.currentTimeMillis() - startTime);
        }
    }
}

