/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.msgloader;

import gov.fhie.transformer.commonadapters.messageprocessor.MessageProcessor;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.transformer.msgloader.MessageLoaderException;
import gov.va.med.hds.hdr.transformer.msgloader.MessageReader;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;

public class DefaultMessageReader
implements MessageReader {
    protected final MessageProcessor processor;

    public DefaultMessageReader(MessageProcessor processor) {
        this.processor = processor;
    }

    public void processMessage(String domain, Reader input) throws MessageLoaderException {
        String appAckError = "";
        boolean success = true;
        StringBuffer rawMessage = new StringBuffer();
        try {
            BufferedReader br = new BufferedReader(input);
            char[] buff = new char[2048];
            int charsRead = 0;
            while ((charsRead = br.read(buff)) != -1) {
                rawMessage.append(String.copyValueOf(buff, 0, charsRead));
            }
            if (rawMessage.length() > 0 && (success = this.isValid(rawMessage))) {
                while (Character.isISOControl(rawMessage.charAt(0))) {
                    rawMessage.deleteCharAt(0);
                }
                if (this.processor == null) {
                    throw new MessageLoaderException("The message processor has not been initialized.");
                }
                if (!this.processor.process(rawMessage.toString(), "MESSAGE_QUEUE")) {
                    IMSException imse = IMSException.getIMSException(new MessageLoaderException("The message failed processing."), (CharSequence)rawMessage.toString());
                    success = true;
                    appAckError = imse.getLocalizedMessage();
                    throw imse;
                }
            }
        }
        catch (IOException ioe) {
            success = false;
            MessageLoaderException mle = new MessageLoaderException("An IO error occurred while reading the message.", ioe);
            appAckError = mle.getLocalizedMessage();
            throw mle;
        }
        finally {
            this.doAcknowledgement(success, appAckError, rawMessage, domain);
        }
    }

    protected boolean isValid(StringBuffer rawMessage) {
        return true;
    }

    protected void doAcknowledgement(boolean success, String error, StringBuffer rawMessage, String domain) {
    }
}

