/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.msgloader;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.util.MBeanRegistrar;
import gov.va.med.hds.hdr.transformer.jms.QueueLocator;
import gov.va.med.hds.hdr.transformer.msgloader.BaseMessageListenerMBean;
import gov.va.med.hds.hdr.transformer.msgloader.HL7TextMessageListener;
import gov.va.med.hds.hdr.transformer.msgloader.MessageLoaderException;
import gov.va.med.hds.hdr.transformer.msgloader.MessageReader;
import java.text.DateFormat;
import java.util.Date;
import java.util.concurrent.atomic.AtomicLong;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.MessageListener;
import javax.jms.Queue;
import javax.jms.QueueReceiver;
import javax.jms.QueueSession;
import javax.jms.Session;
import javax.management.ObjectName;

public abstract class BaseMessageListener
implements MessageListener,
BaseMessageListenerMBean {
    private ObjectName mbeanName;
    private String domain;
    private QueueLocator locator;
    private QueueSession session;
    private QueueReceiver receiver;
    private String queueRealName;
    protected static final DateFormat df = DateTimeUtility.stdDateFmt;
    private static volatile AtomicLong globalMsgsDQd = new AtomicLong(0L);
    private static volatile AtomicLong globalSuccessful = new AtomicLong(0L);
    private static volatile AtomicLong globalFailed = new AtomicLong(0L);
    private static volatile AtomicLong globalLastTime = new AtomicLong(0L);
    private static volatile float globalAvgElapsed;
    private static final Object elapsedMutex;
    private long localMsgsDQd;
    private long localSuccessful;
    private long localFailed;
    private long localLastTime;
    private float localAvgElapsed;
    protected boolean firstTime = true;
    protected MessageReader reader;

    public BaseMessageListener(String domain, QueueLocator locator, MessageReader reader) throws MessageLoaderException {
        if (null == domain || 0 == domain.length()) {
            MessageLoaderException e = new MessageLoaderException("The domain parameter cannot be null or zero length.");
            IMSException.getIMSException(e, null, null, ErrorCode.UNCL_003, new String[]{e.getMessage()});
            throw e;
        }
        if (locator == null) {
            MessageLoaderException e = new MessageLoaderException("The queue locator parameter may not be null.");
            IMSException.getIMSException(e, null, null, ErrorCode.UNCL_003, new String[]{e.getMessage()});
            throw e;
        }
        if (reader == null) {
            MessageLoaderException e = new MessageLoaderException("The queue locator parameter may not be null.");
            IMSException.getIMSException(e, null, null, ErrorCode.UNCL_003, new String[]{e.getMessage()});
            throw e;
        }
        this.domain = domain;
        this.locator = locator;
        this.reader = reader;
        this.initJMSResources();
    }

    public abstract void onMessage(Message var1);

    void initJMSResources() {
        try {
            this.session = this.locator.getConnection().createQueueSession(false, 1);
            Queue queue = this.locator.getQueue((Session)this.session);
            this.queueRealName = queue.getQueueName();
            this.receiver = this.locator.getReciever(this.session, queue);
            this.receiver.setMessageListener((MessageListener)this);
            Thread myThread = Thread.currentThread();
            String threadName = queue.getQueueName() + "[" + myThread.getId() + "]";
            myThread.setName(threadName);
            this.mbeanName = MBeanRegistrar.registerMBean(BaseMessageListener.class.getSimpleName(), this, new String[][]{{"name", threadName}});
        }
        catch (Exception e) {
            MessageLoaderException mle = new MessageLoaderException("An error was encountered while releasing JMS resources.", e);
            IMSException.getIMSException(mle, null, null, ErrorCode.UNCL_003, new String[]{mle.getMessage()});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    void releaseJMSResources() {
        block14: {
            block13: {
                if (this.receiver == null) break block13;
                this.receiver.close();
            }
            try {
                if (this.session != null) {
                    this.session.close();
                }
            }
            catch (JMSException e) {
                MessageLoaderException mle = new MessageLoaderException("An error was encountered while releasing JMS resources.", e);
                IMSException.getIMSException(mle, null, null, ErrorCode.UNCL_003, new String[]{mle.getMessage()});
            }
            MBeanRegistrar.unregisterMBean(this.mbeanName);
            break block14;
            catch (JMSException e) {
                MessageLoaderException mle;
                try {
                    mle = new MessageLoaderException("An error was encountered while releasing JMS resources.", e);
                    IMSException.getIMSException(mle, null, null, ErrorCode.UNCL_003, new String[]{mle.getMessage()});
                }
                catch (Throwable throwable) {
                    try {
                        if (this.session != null) {
                            this.session.close();
                        }
                    }
                    catch (JMSException e2) {
                        MessageLoaderException mle2 = new MessageLoaderException("An error was encountered while releasing JMS resources.", e2);
                        IMSException.getIMSException(mle2, null, null, ErrorCode.UNCL_003, new String[]{mle2.getMessage()});
                    }
                    MBeanRegistrar.unregisterMBean(this.mbeanName);
                    throw throwable;
                }
                try {
                    if (this.session != null) {
                        this.session.close();
                    }
                }
                catch (JMSException e3) {
                    mle = new MessageLoaderException("An error was encountered while releasing JMS resources.", e3);
                    IMSException.getIMSException(mle, null, null, ErrorCode.UNCL_003, new String[]{mle.getMessage()});
                }
                MBeanRegistrar.unregisterMBean(this.mbeanName);
            }
        }
    }

    protected String getDomain() {
        return this.domain;
    }

    protected String getQName() {
        return this.queueRealName;
    }

    protected void incrementMsgsDQd() {
        globalMsgsDQd.incrementAndGet();
        ++this.localMsgsDQd;
    }

    protected void incrementSuccessful() {
        globalSuccessful.incrementAndGet();
        ++this.localSuccessful;
    }

    protected void incrementFailed() {
        globalFailed.incrementAndGet();
        ++this.localFailed;
    }

    protected void setGlobalLastTime(long lastTime) {
        globalLastTime.set(lastTime);
        this.localLastTime = lastTime;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void accumulateElapse(long elapsed) {
        Object object = elapsedMutex;
        synchronized (object) {
            long msgs = this.getMsgsDQd();
            globalAvgElapsed = (globalAvgElapsed * (float)msgs + (float)elapsed) / (float)msgs;
        }
        this.localAvgElapsed = (this.localAvgElapsed * (float)this.localMsgsDQd + (float)elapsed) / (float)this.localMsgsDQd;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void resetStats() {
        Object object = elapsedMutex;
        synchronized (object) {
            globalAvgElapsed = 0.0f;
        }
        globalMsgsDQd.set(0L);
        globalSuccessful.set(0L);
        globalFailed.set(0L);
    }

    public final void resetLocalStats() {
        this.localFailed = 0L;
        this.localSuccessful = 0L;
        this.localMsgsDQd = 0L;
        this.localAvgElapsed = 0L;
    }

    public static void printStats() {
        if (0L < globalMsgsDQd.get()) {
            System.out.println(new StringBuffer(HL7TextMessageListener.class.getName()).append("\n\tNumber of messages processed: ").append(globalMsgsDQd).append("\t\t   Last Time: ").append(0L < globalLastTime.get() ? df.format(new Date(globalLastTime.get())) : "").append("\n\t\tSuccessful: ").append(globalSuccessful.get()).append("\n\t\t    Failed: ").append(globalFailed.get()).append("\n\t\tAvg elapse: ").append((float)Math.round(globalAvgElapsed * 100.0f) / 100.0f).append("\n").toString());
        }
    }

    public final float getAverageElapsed() {
        return (float)Math.round(this.localAvgElapsed * 100.0f) / 100.0f;
    }

    public final long getFailed() {
        return this.localFailed;
    }

    public final long getMsgsDQd() {
        return this.localMsgsDQd;
    }

    public final long getSuccessful() {
        return this.localSuccessful;
    }

    public final Date getLastTime() {
        return 0L == this.localLastTime ? (Date)null : new Date(this.localLastTime);
    }

    public static final void resetGlobalStats() {
        BaseMessageListener.resetStats();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final float getGlobalAverageElapsed() {
        Object object = elapsedMutex;
        synchronized (object) {
            return (float)Math.round(globalAvgElapsed / 100.0f) * 100.0f;
        }
    }

    public static final long getGlobalFailed() {
        return globalFailed.get();
    }

    public static final long getGlobalMsgsDQd() {
        return globalMsgsDQd.get();
    }

    public static final long getGlobalSuccessful() {
        return globalSuccessful.get();
    }

    public static final Date getGlobalLastTime() {
        return new Date(globalLastTime.get());
    }

    static {
        elapsedMutex = new Object();
    }
}

