/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.jms;

import gov.fhie.common.properties.PropertyElement;
import gov.va.med.hds.hdr.transformer.jms.QueueLocator;
import gov.va.med.hds.hdr.transformer.jms.QueueLocatorException;
import java.lang.reflect.Constructor;
import java.util.Properties;

public class QueueLocatorFactory {
    private static final String ATTR_CLASS = "class";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_VALUE = "value";

    private QueueLocatorFactory() {
    }

    public static final QueueLocator createInstance(PropertyElement queueLocatorElement) throws QueueLocatorException {
        QueueLocator queueLocator = null;
        String generalMessage = "Error creating Queue Locator.";
        Properties env = new Properties();
        PropertyElement[] qlProps = queueLocatorElement.getChildProperties();
        for (int i = 0; i < qlProps.length; ++i) {
            String key = qlProps[i].getAttribute(ATTR_KEY);
            String value = qlProps[i].getAttribute(ATTR_VALUE);
            if (key == null || "".equals(key) || value == null || "".equals(value)) continue;
            env.put(key, value);
        }
        try {
            String clazz;
            if (queueLocatorElement != null && (clazz = queueLocatorElement.getAttribute(ATTR_CLASS)) != null && !"".equals(clazz)) {
                Constructor<?> constructor = Class.forName(clazz).getConstructor(Properties.class);
                queueLocator = (QueueLocator)constructor.newInstance(env);
            }
            if (queueLocator == null) {
                throw new QueueLocatorException("QueueLocator concrete class not defined properly in configuration file.");
            }
        }
        catch (QueueLocatorException e) {
            throw e;
        }
        catch (Exception e) {
            throw new QueueLocatorException("An error was encountered while creating queue locator.", e);
        }
        return queueLocator;
    }
}

