/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository;

import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;

public class XMLDocumentMessageMetaData
implements MessageMetaData {
    private Element clinicalElement = null;

    public XMLDocumentMessageMetaData(Document metaData) {
        this.clinicalElement = metaData.getRootElement().element("instance");
    }

    private String getClinicalData(String name) {
        String value = "";
        List attributes = this.clinicalElement.elements("attribute");
        for (Element attr : attributes) {
            String attrName = attr.attribute("name").getText();
            if (attrName == null || !attrName.equalsIgnoreCase(name)) continue;
            value = attr.element("field").getText();
            break;
        }
        return value;
    }

    public String getLocalId() {
        return this.getClinicalData("dfn");
    }

    public String getPidDomain() {
        return this.getClinicalData("stationNo");
    }

    public String getSendingApplication() {
        return this.getClinicalData("sendingApplication");
    }

    public String getFacilityId() {
        return this.getClinicalData("sendingFacility");
    }

    public String getMessageDateTime() {
        return DateTimeUtility.normalizeDateString(this.getClinicalData("messageDateTime"), this.getFacilityId());
    }

    public String getVersion() {
        return this.getClinicalData("version");
    }

    public String getMessageControlId() {
        return this.getClinicalData("messageControlId");
    }

    public String getMessageType() {
        return this.getClinicalData("messageType");
    }

    public String getClinicalId() {
        return this.getClinicalData("clinicalId");
    }

    public String getClinicallyRelevantDate() {
        return DateTimeUtility.normalizeDateString(this.getClinicalData("clinicallyRelevantDate"), this.getFacilityId());
    }
}

