/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository;

import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;

public class StringArrayMessageMetaData
implements MessageMetaData {
    private static final int IDX_LOCALPID = 0;
    private static final int IDX_PIDDOMAIN = 1;
    private static final int IDX_SENDINGAPPLICATION = 2;
    private static final int IDX_SENDINGFACILITY = 3;
    private static final int IDX_MESSAGEDATETIME = 4;
    private static final int IDX_MESSAGETYPE = 5;
    private static final int IDX_MESSAGECONTROLID = 6;
    private static final int IDX_VERSION = 7;
    private static final int IDX_CLINICALLYRELEVANTDATE = 9;
    private static final int IDX_CLINICALID = 10;
    private String[] dbData = null;

    public StringArrayMessageMetaData(String[] dbData) {
        this.dbData = dbData;
    }

    public String getLocalId() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 0) {
            retVal = this.dbData[0];
        }
        return retVal;
    }

    public String getPidDomain() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 1) {
            retVal = this.dbData[1];
        }
        return retVal;
    }

    public String getSendingApplication() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 2) {
            retVal = this.dbData[2];
        }
        return retVal;
    }

    public String getFacilityId() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 3) {
            retVal = this.dbData[3];
        }
        return retVal;
    }

    public String getMessageDateTime() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 4) {
            retVal = this.dbData[4];
        }
        return DateTimeUtility.normalizeDateString(retVal, this.getFacilityId());
    }

    public String getVersion() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 7) {
            retVal = this.dbData[7];
        }
        return retVal;
    }

    public String getMessageControlId() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 6) {
            retVal = this.dbData[6];
        }
        return retVal;
    }

    public String getMessageType() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 5) {
            retVal = this.dbData[5];
        }
        return retVal;
    }

    public String getClinicalId() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 10) {
            retVal = this.dbData[10];
        }
        return retVal;
    }

    public String getClinicallyRelevantDate() {
        String retVal = null;
        if (this.dbData != null && this.dbData.length > 9) {
            retVal = this.dbData[9];
        }
        return DateTimeUtility.normalizeDateString(retVal, this.getFacilityId());
    }
}

