/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository;

import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterFactory;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor.MessageProcessorException;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.HL7Message;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.XMLDocumentMessageMetaData;
import java.util.Date;
import org.dom4j.Document;

public class HxHL7Message
implements HL7Message {
    private static final String XP_CLINICAL_DATA_TEMPLATE = "transformer/clinical-data-templates/template[@message-type='MESSAGE_TYPE']/@template-name";
    private final String hl7Message;
    private final MessageMetaData metaData;

    public HxHL7Message(String hl7Message) {
        this.hl7Message = hl7Message;
        this.metaData = this.getMessageMetaData();
    }

    private MessageMetaData getMessageMetaData() {
        try {
            PropertyMgr propertyMgr = PropertyMgr.getInstance();
            ResultAdapter resultAdapter = ResultAdapterFactory.createResultAdapter(this.hl7Message);
            String messageType = resultAdapter.getMessageType(this.hl7Message);
            String xPath = XP_CLINICAL_DATA_TEMPLATE.replaceFirst("MESSAGE_TYPE", messageType);
            String templateName = propertyMgr.getProperty(xPath).getValue();
            if (templateName == null) {
                throw new MessageProcessorException("Could not retrieve template name from configuration file using XPATH: " + xPath);
            }
            Document graph = (Document)resultAdapter.adapt(this.hl7Message, templateName);
            return new XMLDocumentMessageMetaData(graph);
        }
        catch (Exception e) {
            throw IMSException.getIMSException("HxHL7Message: An error occurred while trying to get message meta-data from message.", e);
        }
    }

    public String getFacilityId() {
        return this.metaData.getFacilityId();
    }

    public String getMessage() {
        return this.hl7Message;
    }

    public String getMessageControlId() {
        return this.metaData.getMessageControlId();
    }

    public String getClinicalId() {
        return this.metaData.getClinicalId();
    }

    public Date getClinicallyRelevantDate() {
        return new Date(DateTimeUtility.getMilliSecond(this.metaData.getClinicallyRelevantDate()));
    }

    public String getHl7Version() {
        return this.metaData.getVersion();
    }

    public String getLocalPid() {
        return this.metaData.getLocalId();
    }

    public String getMessageDateTime() {
        return this.metaData.getMessageDateTime();
    }

    public String getMessageType() {
        return this.metaData.getMessageType();
    }

    public String getPidDomain() {
        return "MED.VA.GOV/" + this.metaData.getPidDomain();
    }

    public String getSendingApplication() {
        return this.metaData.getSendingApplication();
    }

    public String getStationNumber() {
        return this.metaData.getPidDomain();
    }
}

