/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.transformer.commonadapters.messageprocessor.MessageProcessor;
import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentParser;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.thread.Synchronizer;
import gov.va.med.hds.hdr.common.util.RegularExpressionHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import java.lang.reflect.Constructor;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;

public class RoutingClinicalProcessor
extends MessageProcessor {
    private Map<String, Object> processorMap = new HashMap<String, Object>();

    public RoutingClinicalProcessor(String domain, PropertyElement[] properties, Synchronizer synchronizer, boolean isAuditing) {
        super(domain, properties, synchronizer, isAuditing);
        this.initProcessorMap();
    }

    private void initProcessorMap() {
        for (int i = 0; i < this.properties.length; ++i) {
            if (!this.properties[i].getNodeName().equals("processor")) continue;
            String pattern = this.properties[i].getAttribute("pattern");
            String processorType = this.properties[i].getAttribute("processorType");
            Boolean audit = new Boolean("true".equals(this.properties[i].getAttribute("audit")));
            try {
                Constructor<?> c = Class.forName(processorType).getConstructor(String.class, PropertyElement[].class, Synchronizer.class, Boolean.TYPE);
                Object processor = c.newInstance(this.domain, null, this.synchronizer, audit);
                this.processorMap.put(pattern, processor);
                continue;
            }
            catch (Exception e) {
                IMSException.getIMSException("Error creating processor class.", e);
            }
        }
    }

    public boolean process(String rawMessage, String source) {
        String messageType = this.getMessageType(rawMessage);
        Set<String> keys = this.processorMap.keySet();
        Iterator<String> iKeys = keys.iterator();
        MessageProcessor processor = null;
        while (iKeys.hasNext()) {
            String regex = iKeys.next();
            if (!messageType.matches(regex)) continue;
            processor = (MessageProcessor)this.processorMap.get(regex);
            break;
        }
        if (processor != null) {
            return processor.process(rawMessage, source);
        }
        IMSException.getIMSException("There is no clinical processor mapped to the message type: " + messageType, (CharSequence)rawMessage);
        return true;
    }

    public String getMessageType(String rawMessage) {
        StringBuffer sbMessageType = new StringBuffer();
        HL7MessageInfoImpl messageInfo = new HL7MessageInfoImpl(rawMessage);
        String segment = rawMessage.split("\r")[0];
        if (segment != null && segment.length() != 0) {
            String[] fields = HL7SegmentParser.parseLine(segment, (HL7MessageInfo)messageInfo);
            String[] msgType = fields[8].split(RegularExpressionHelper.escape(messageInfo.getComponentSeparator()));
            sbMessageType.append(fields[2]).append('_').append(msgType[0]).append('_').append(msgType[1]);
        }
        return sbMessageType.toString();
    }
}

