/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.transformer.hl7adapters.hl7repository.HL7RepositoryWrapper;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.vhim.common.Template;
import gov.va.med.hds.hdr.common.thread.Synchronizer;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor.AbstractHL7ClinicalProcessor;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;

public class RelationalClinicalProcessor
extends AbstractHL7ClinicalProcessor {
    public RelationalClinicalProcessor(String domain, PropertyElement[] properties, Synchronizer synchronzier, boolean isAuditing) {
        super(domain, properties, synchronzier, isAuditing);
    }

    protected MessageMetaData getMetaData(ResultAdapter resultAdapter, String rawMessage, String templateName) {
        Template template = null;
        try {
            template = (Template)resultAdapter.adapt(rawMessage, templateName);
        }
        catch (Exception e) {
            throw IMSException.getIMSException("An error occurred while getting the result adapter.", e);
        }
        return template;
    }

    protected void saveMessage(String domain, String rawMessage, String template, MessageMetaData metaData, String source) {
        try {
            ((Template)metaData).store();
        }
        catch (Exception e) {
            throw IMSException.getIMSException("An error occurred while trying to save the message.", e);
        }
    }

    protected String getClinicalId(Object metaData) {
        Template template = (Template)metaData;
        return template.getClinicalId();
    }

    protected void auditMessage(String rawMessage, String templateName, Object data) {
        try {
            HL7RepositoryWrapper wrapper = new HL7RepositoryWrapper(this.domain);
            wrapper.saveMessage(rawMessage, (MessageMetaData)data, "MESSAGE_QUEUE");
        }
        catch (Exception e) {
            throw IMSException.getIMSException("An error occurred while trying to audit the message to the HL7 repository.", e);
        }
    }
}

