/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.transformer.commonadapters.messageprocessor.MessageProcessor;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.domain.DataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocator;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.XMLPatientBuilder;
import gov.va.med.hds.hdr.common.thread.Synchronizer;

public class PatientCorrelationProcessor
extends MessageProcessor {
    private DataDomain dataDomain = null;

    public PatientCorrelationProcessor() {
        super(null, null, null, false);
    }

    public PatientCorrelationProcessor(String domain, PropertyElement[] properties, Synchronizer synchronizer, boolean isAuditing) {
        super(domain, null, synchronizer, isAuditing);
    }

    public boolean process(String rawMessage, String fileName) {
        boolean retVal = false;
        try {
            if (this.dataDomain == null) {
                this.dataDomain = DataDomainLocator.getInstance().locate(this.domain);
            }
            Patient patient = XMLPatientBuilder.buildPaitient(rawMessage);
            this.dataDomain.correlatePatient(patient);
            if (this.isAuditing) {
                this.auditMessage(rawMessage, "DNS:hdrims.DNS           /PatientTemplate", patient);
            }
            retVal = true;
        }
        catch (Exception e) {
            throw IMSException.getIMSException("An error occurred while trying to correlate the patient.", e);
        }
        return retVal;
    }
}

