/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.transformer.hl7adapters.hl7repository.HL7RepositoryWrapper;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.thread.Synchronizer;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor.AbstractHL7ClinicalProcessor;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.XMLDocumentMessageMetaData;
import org.dom4j.Document;

public class HL7RepositoryClinicalProcessor
extends AbstractHL7ClinicalProcessor {
    public HL7RepositoryClinicalProcessor(String domain, PropertyElement[] properties, Synchronizer synchronizer, boolean isAuditing) {
        super(domain, properties, synchronizer, isAuditing);
    }

    protected MessageMetaData getMetaData(ResultAdapter resultAdapter, String rawMessage, String templateName) {
        XMLDocumentMessageMetaData metaData = null;
        try {
            Document graph = (Document)resultAdapter.adapt(rawMessage, templateName);
            metaData = new XMLDocumentMessageMetaData(graph);
        }
        catch (Exception e) {
            throw IMSException.getIMSException("An error occurred while getting the result adapter.", e);
        }
        return metaData;
    }

    protected void saveMessage(String domain, String rawMessage, String templateName, MessageMetaData metaData, String source) {
        try {
            HL7RepositoryWrapper wrapper = new HL7RepositoryWrapper(this.domain);
            wrapper.saveMessage(rawMessage, metaData, source);
        }
        catch (Exception e) {
            throw IMSException.getIMSException("An error occurred while trying to save the message.", e);
        }
    }

    protected String getClinicalId(Object ometaData) {
        MessageMetaData metaData = (MessageMetaData)ometaData;
        return metaData.getClinicalId();
    }
}

