/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.transformer.commonadapters.messageprocessor.MessageProcessor;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.hl7.ApplicationAcknowledgmentResponse;
import gov.va.med.hds.hdr.common.thread.Synchronizer;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.hl7.HL7Service;

public class ApplicationAcknowledgementProcessor
extends MessageProcessor {
    private final HL7Service hl7Service = ServiceLocator.getInstance().getHL7Service();
    private final ApplicationAcknowledgmentResponse appAckResp = this.hl7Service.getApplicationAcknowledgeResponseObject();

    public ApplicationAcknowledgementProcessor(String domain, PropertyElement[] properties, Synchronizer synchronizer, boolean isAuditing) {
        super(domain, null, synchronizer, isAuditing);
    }

    public ApplicationAcknowledgementProcessor(String domain) {
        this(domain, null, null, false);
    }

    public boolean process(String rawMessage, String fileName) {
        boolean retVal = false;
        try {
            this.appAckResp.sendApplicationAck(rawMessage);
            if (this.isAuditing) {
                this.auditMessage(rawMessage, null, null);
            }
            retVal = true;
        }
        catch (Exception e) {
            if (e instanceof IMSException) {
                throw (IMSException)e;
            }
            throw IMSException.getIMSException(e, (CharSequence)"Application ACK exception", "ApplicationAcknowledgementProcessor:process(String,String)", ErrorCode.HL7M_011, new String[]{rawMessage});
        }
        return retVal;
    }
}

