/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.commonadapters.messageprocessor.MessageProcessor;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.hl7.Acknowledgment;
import gov.va.med.hds.hdr.busobj.hl7.JDOMDocumentAcknowledgmentBuilder;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.Command;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.CommandFactory;
import gov.va.med.hds.hdr.common.hl7command.norespcommand.InvalidParameterException;
import gov.va.med.hds.hdr.common.thread.Synchronizer;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.dao.HL7AuditDAO;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterFactory;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor.MessageProcessorException;
import org.dom4j.Document;
import org.dom4j.Element;

public class AdtProcessor
extends MessageProcessor {
    private static final String XP_MAPTEMPLATE = "transformer/mapping-type-codes/mapping-type-code[@message-type='MESSAGE_TYPE']/@template";
    private static final String XP_ENTRYPOINT = "transformer/rpcbroker[@type='HL7' and @encoding='JMS']/entry-point[@code='WHAT_CODE']";
    private static final String XP_WHATCODE = "//graph/instance[@role='rpc' and @type='RemoteProcedureCall']/instance[@role='what' and @type='RPCParameter']/attribute[@name='value' and @type='PlainText']/field[@name='value']";

    public AdtProcessor() {
        super(null, null, null, false);
    }

    public AdtProcessor(String domain, PropertyElement[] properties, Synchronizer synchronizer, boolean isAuditing) {
        super(domain, null, synchronizer, isAuditing);
    }

    public boolean process(String rawMessage, String fileName) {
        PropertyMgr pm = PropertyMgr.getInstance();
        if (rawMessage != null && rawMessage.length() != 0) {
            try {
                ResultAdapter resultAdapter = ResultAdapterFactory.createResultAdapter(rawMessage);
                String messageType = resultAdapter.getMessageType(rawMessage);
                pm = PropertyMgr.getInstance();
                String xPath = XP_MAPTEMPLATE.replaceFirst("MESSAGE_TYPE", messageType);
                String templateName = pm.getProperty(xPath).getValue();
                if (templateName == null) {
                    throw new MessageProcessorException("Could not retrieve template name from configuration file using XPATH: " + xPath);
                }
                Document graph = (Document)resultAdapter.adapt(rawMessage, templateName);
                this.logMessage(rawMessage, graph);
                Element whatCode = this.getWhatCodeDomainValue(graph);
                String rpcType = whatCode.getText();
                PropertyElement entryPoint = pm.getProperty(XP_ENTRYPOINT.replaceFirst("WHAT_CODE", rpcType));
                Command c = CommandFactory.getInstance().createCommand(entryPoint);
                c.execute(graph);
            }
            catch (Exception e) {
                e.printStackTrace();
                throw IMSException.getIMSException(e, (CharSequence)rawMessage, null, ErrorCode.GENM_033, new String[]{"AdtProcessor::process", e.getMessage()});
            }
        }
        return true;
    }

    private Element getWhatCodeDomainValue(Document d) throws InvalidParameterException {
        Element whatCode = (Element)d.selectSingleNode(XP_WHATCODE);
        if (whatCode == null) {
            throw new InvalidParameterException("Could not find what code in graph.\nGraph: \n" + d.asXML());
        }
        return whatCode;
    }

    private void logMessage(String message, Document document) throws Exception {
        Acknowledgment ack = JDOMDocumentAcknowledgmentBuilder.buildAcknowledgment(document);
        String origMessageControlId = ack.getOriginatingMessageControlId();
        if (origMessageControlId != null && origMessageControlId.length() > 0) {
            String dataDomain = ServiceLocator.getInstance().getHL7Service().getDataDomainId(origMessageControlId);
            HL7AuditDAO dao = ServiceLocator.getInstance().getDAOFactory().createHL7AuditLogDAO();
            dao.addMessage(dataDomain, origMessageControlId, message);
        }
    }
}

