/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.commonadapters.messageprocessor.MessageProcessor;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.domain.DataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocator;
import gov.va.med.hds.hdr.busobj.patient.HL7PatientBuilder;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.common.thread.Synchronizer;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.rules.RulesEngine;
import gov.va.med.hds.hdr.service.session.ImsSession;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterFactory;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7processor.MessageProcessorException;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.MessageMetaData;

public abstract class AbstractHL7ClinicalProcessor
extends MessageProcessor {
    private static final String XP_CLINICAL_DATA_TEMPLATE = "transformer/clinical-data-templates/template[@message-type='MESSAGE_TYPE']/@template-name";
    private static final PatientIdentifier DUMMY_PID = new PatientIdentifier("DUMMY", "DUMMY");
    private static PropertyMgr propertyMgr = PropertyMgr.getInstance();
    protected DataDomain dataDomain = null;

    public AbstractHL7ClinicalProcessor(String domain, PropertyElement[] properties, Synchronizer synchronizer, boolean isAuditing) {
        super(domain, properties, synchronizer, isAuditing);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean process(String rawMessage, String source) {
        boolean retVal = false;
        ImsSession session = null;
        long startProcess = System.currentTimeMillis();
        if (rawMessage == null || rawMessage.length() == 0) {
            return retVal;
        }
        Object mutex = null;
        String clinicalId = null;
        PatientIdentifier nationalIdentifier = null;
        HL7MessageInfoImpl messageInfo = new HL7MessageInfoImpl(rawMessage);
        try {
            long startTime = System.currentTimeMillis();
            ResultAdapter resultAdapter = ResultAdapterFactory.createResultAdapter(rawMessage);
            String messageType = resultAdapter.getMessageType(rawMessage);
            String xPath = XP_CLINICAL_DATA_TEMPLATE.replaceFirst("MESSAGE_TYPE", messageType);
            String templateName = propertyMgr.getProperty(xPath).getValue();
            if (templateName == null) {
                throw new MessageProcessorException("Could not retrieve template name from configuration file using XPATH: " + xPath);
            }
            if (this.dataDomain == null) {
                this.dataDomain = DataDomainLocator.getInstance().locate(this.domain);
            }
            MessageMetaData metaData = this.getMetaData(resultAdapter, rawMessage, templateName);
            clinicalId = metaData.getClinicalId();
            mutex = this.synchronizer.getSyncObject(clinicalId);
            Patient patient = HL7PatientBuilder.buildPatient(rawMessage, (HL7MessageInfo)messageInfo);
            nationalIdentifier = patient.getFirstIdentifier(2);
            if (nationalIdentifier == null) {
                nationalIdentifier = DUMMY_PID;
            }
            Object object = mutex;
            synchronized (object) {
                try {
                    session = ServiceLocator.getInstance().getImsSession();
                    try {
                        this.dataDomain.correlatePatientAsync(patient);
                    }
                    catch (Exception e) {
                        IMSException.getIMSException("An error occured while correlating the patient in the domain.", e);
                    }
                    this.saveMessage(this.domain, rawMessage, templateName, metaData, source);
                    if (this.isAuditing) {
                        this.auditMessage(rawMessage, templateName, metaData);
                    }
                }
                catch (Exception e) {
                    if (session != null) {
                        session.doException();
                    }
                    throw e;
                }
                finally {
                    if (session != null) {
                        session.doPreDestroy();
                        session.doDestroy();
                    }
                }
            }
            retVal = true;
        }
        catch (Exception e) {
            IMSException imse = IMSException.getIMSException(e, (CharSequence)rawMessage, null, ErrorCode.GENM_033, new String[]{"HL7RepositoryClinicalProcessor::process", e.getMessage()});
            try {
                RulesEngine rulesEngine = ServiceLocator.getInstance().getRulesEngine();
                retVal = !rulesEngine.reprocessErroredMessage(imse);
            }
            catch (Exception e1) {
                IMSException.getIMSException("An error occurred while locating rules engine service.", e1);
            }
        }
        return retVal;
    }

    protected abstract MessageMetaData getMetaData(ResultAdapter var1, String var2, String var3);

    protected abstract void saveMessage(String var1, String var2, String var3, MessageMetaData var4, String var5);
}

