/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.parser.tokenfilter;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserEvent;
import gov.va.med.hds.hdr.transformer.hl7.parser.tokenfilter.AbstractTokenFilter;

public class RdvSprDateTokenFilter
extends AbstractTokenFilter {
    public RdvSprDateTokenFilter(int subcomponentIndex) {
        super("Stored Procedure Request", 4, 2, subcomponentIndex);
    }

    protected void doFilter(HL7MessageParserEvent event) {
        String dateParameter = event.getText();
        if (null == dateParameter || dateParameter.length() < 9) {
            event.setText("");
        } else if ((dateParameter = dateParameter.substring(8)).length() == 7) {
            try {
                int year = Integer.parseInt(dateParameter.substring(0, 3)) + 1700;
                dateParameter = year + dateParameter.substring(3);
                event.setText(dateParameter);
            }
            catch (Exception e) {
                IMSException.getIMSException("Error parsing RPC input date. Original date: " + dateParameter, e);
            }
        }
    }
}

