/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.parser.tokenfilter;

import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserEvent;
import gov.va.med.hds.hdr.hl7.parser.tokenfilter.HL7ParserTokenFilter;
import gov.va.med.hds.hdr.transformer.hl7.parser.tokenfilter.PatientIdentifierTypeCodeFilter;

public class PatientSiteQualifierTokenFilter
implements HL7ParserTokenFilter {
    private PatientIdentifierTypeCodeFilter identifierTypeCodeFilter;

    public PatientSiteQualifierTokenFilter(PatientIdentifierTypeCodeFilter identifierTypeCodeFilter) {
        this.identifierTypeCodeFilter = identifierTypeCodeFilter;
    }

    public void applyFilter(String segmentName, HL7MessageParserEvent event) {
        String siteId = event.getText();
        if ("NI".equals(this.identifierTypeCodeFilter.getIdentifierTypeCode())) {
            PropertyMgr pm = PropertyMgr.getInstance();
            event.setText(pm.getProperty("transformer/national-id-domain").getValue());
        } else if ("PI".equals(this.identifierTypeCodeFilter.getIdentifierTypeCode())) {
            String domainNm = "FHIE.GOV/VA0";
            if ("200CH".equals(siteId) || "200HD".equals(siteId)) {
                domainNm = "FHIE.GOV/DOD0";
            }
            PropertyMgr pm = PropertyMgr.getInstance(domainNm);
            event.setText(pm.getProperty("naming_entity_prefix").getValue() + event.getText());
        }
    }

    public String getTokenFilterKey() {
        return "Patient Identifier-3.6.2";
    }
}

