/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.parser.tokenfilter;

import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserEvent;
import gov.va.med.hds.hdr.hl7.parser.tokenfilter.HL7ParserTokenFilter;

public abstract class AbstractTokenFilter
implements HL7ParserTokenFilter {
    protected String segmentName;
    protected int fieldIndex;
    protected int componentIndex;
    protected int subcomponentIndex;

    public AbstractTokenFilter(String segmentName, int fieldIndex, int componentIndex, int subcomponentIndex) {
        this.setSegmentName(segmentName);
        this.setFieldIndex(fieldIndex);
        this.setComponentIndex(componentIndex);
        this.setSubcomponentIndex(subcomponentIndex);
    }

    public void applyFilter(String segmentName, HL7MessageParserEvent event) {
        if (this.getSegmentName().equals(segmentName) && event.getFieldIndex() == this.getFieldIndex() && event.getComponentIndex() == this.getComponentIndex() && event.getSubcomponentIndex() == this.getSubcomponentIndex()) {
            this.doFilter(event);
        }
    }

    public String getTokenFilterKey() {
        return this.segmentName + "-" + this.fieldIndex + "." + this.componentIndex + "." + this.subcomponentIndex;
    }

    protected abstract void doFilter(HL7MessageParserEvent var1);

    public int getComponentIndex() {
        return this.componentIndex;
    }

    public void setComponentIndex(int componentIndex) {
        if (componentIndex < 0) {
            throw new IllegalArgumentException("Invalid component index (" + componentIndex + ").");
        }
        this.componentIndex = componentIndex;
    }

    public int getFieldIndex() {
        return this.fieldIndex;
    }

    public void setFieldIndex(int fieldIndex) {
        if (fieldIndex < 0) {
            throw new IllegalArgumentException("Invalid field index (" + fieldIndex + ").");
        }
        this.fieldIndex = fieldIndex;
    }

    public String getSegmentName() {
        return this.segmentName;
    }

    public void setSegmentName(String segmentName) {
        if (segmentName == null || segmentName.length() == 0) {
            throw new IllegalArgumentException("Invalid segment name (" + segmentName + ").");
        }
        this.segmentName = segmentName;
    }

    public int getSubcomponentIndex() {
        return this.subcomponentIndex;
    }

    public void setSubcomponentIndex(int subcomponentIndex) {
        if (subcomponentIndex < 0) {
            throw new IllegalArgumentException("Invalid subcomponent index (" + subcomponentIndex + ").");
        }
        this.subcomponentIndex = subcomponentIndex;
    }
}

