/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.parser;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.transformer.hl7.parser.HL7Validator;
import java.io.IOException;
import java.io.InputStreamReader;
import java.net.Socket;
import java.util.Properties;
import java.util.Set;

public class HL7ValidatorMWB
extends HL7Validator {
    private String msgType;
    private String host;
    private int port;
    private static final int BUFF_LEN = 2048;

    public HL7ValidatorMWB(String msgType, Properties properties) throws Exception {
        this.msgType = msgType;
        this.initValidation(properties);
    }

    private void initValidation(Properties properties) {
        if (null != properties) {
            Set<Object> keys = properties.keySet();
            for (String string : keys) {
                if (!"url".equals(string)) continue;
                String[] address = properties.getProperty(string).split(":");
                this.host = address[0];
                this.port = Integer.parseInt(address[1]);
            }
        }
    }

    private Socket openSocket() {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
        }
        catch (Exception e) {
            throw IMSException.getIMSException("MWB validation server on " + this.host + ":" + this.port + " for " + this.msgType + " is unavailable", e);
        }
        return socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean valid(String msg) {
        try {
            StringBuffer sb = new StringBuffer();
            String string = this.msgType;
            synchronized (string) {
                int len;
                Socket validationServer = this.openSocket();
                if (null == validationServer) {
                    return false;
                }
                validationServer.getOutputStream().write(msg.getBytes());
                InputStreamReader reply = new InputStreamReader(validationServer.getInputStream());
                char[] buff = new char[2048];
                do {
                    len = reply.read(buff);
                    sb.append(buff, 0, len);
                } while (2048 == len);
                validationServer.close();
            }
            msg = sb.toString().substring(msg.indexOf("MSH"));
            if (null != msg) {
                String[] segments = msg.split(HL7MessageInfo.LINE_DELIMETER);
                for (int i = 1; i < segments.length; ++i) {
                    String segment = segments[i].trim();
                    if (!segment.startsWith("MSA")) continue;
                    if (segment.startsWith("MSA^AA")) break;
                    IOException e = new IOException("Received NACK from MWB validation service.\nResponse: " + msg);
                    e.printStackTrace();
                    throw e;
                }
                return true;
            }
        }
        catch (Exception e) {
            IMSException.getIMSException(e);
        }
        return false;
    }
}

