/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.parser;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.transformer.hl7.parser.HL7Validator;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.dom4j.Attribute;

public class HL7ValidatorFactory {
    private static Map<String, HL7Validator> validators = new Hashtable<String, HL7Validator>();
    private static boolean initialized = false;
    private static final String VALIDATORS_PATH = "transformer/validators/validator[@enable=\"true\"]";
    private static final String CLASS_NAME_ATTRIB = "class";
    private static final String MSG_TYPE_ATTRIB = "message-type";
    private static final String PROPERTIES_PATH = "property";

    public static Map getHL7Validators() {
        if (validators.isEmpty() && !initialized) {
            HL7ValidatorFactory.initValidators();
        }
        return validators;
    }

    private static synchronized void initValidators() {
        if (validators.isEmpty() && !initialized) {
            PropertyMgr propMgr = PropertyMgr.getInstance();
            PropertyElement[] validatorProps = propMgr.getProperties(VALIDATORS_PATH);
            for (int i = 0; i < validatorProps.length; ++i) {
                String msgType = validatorProps[i].getAttribute(MSG_TYPE_ATTRIB);
                String className = validatorProps[i].getAttribute(CLASS_NAME_ATTRIB);
                try {
                    Class<?> clazz = Class.forName(className);
                    if (null == clazz) continue;
                    HL7Validator validator = (HL7Validator)clazz.getConstructor(String.class, Properties.class).newInstance(msgType, HL7ValidatorFactory.getValidatorProperties(propMgr, validatorProps[i]));
                    validators.put(msgType, validator);
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        initialized = true;
    }

    private static Properties getValidatorProperties(PropertyMgr propMgr, PropertyElement validator) {
        Properties props = null;
        PropertyElement[] propProperties = propMgr.getProperties(PROPERTIES_PATH, validator);
        if (0 < propProperties.length) {
            props = new Properties();
            for (int i = 0; i < propProperties.length; ++i) {
                List attribs = propProperties[i].getAttributes();
                for (Attribute attrib : attribs) {
                    props.put(attrib.getName(), attrib.getValue());
                }
            }
        }
        return props;
    }
}

