/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.model;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegment;
import java.lang.reflect.Constructor;

public class MshSegmentFactory {
    private static final String XP_SEGMENT_TYPES = "transformer/hl7segmenttypes/*";
    private static final String ATTR_KEY = "key";
    private static final String ATTR_CLASS = "class";

    private MshSegmentFactory() {
    }

    public static MshSegment createSegment(String[] fieldStrings, HL7MessageInfo messageInfo) {
        MshSegment segment = null;
        try {
            Class clazz = MshSegmentFactory.getSegmentClass(messageInfo.getVersion());
            Constructor constructor = clazz.getConstructor(String[].class, HL7MessageInfo.class);
            segment = (MshSegment)constructor.newInstance(fieldStrings, messageInfo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return segment;
    }

    private static Class getSegmentClass(String version) throws ClassNotFoundException {
        Class<?> clazz = null;
        String key = version + "MSH";
        PropertyMgr pmgr = PropertyMgr.getInstance();
        PropertyElement[] propertyElements = pmgr.getProperties(XP_SEGMENT_TYPES);
        for (int i = 0; i < propertyElements.length; ++i) {
            String k = propertyElements[i].getAttribute(ATTR_KEY);
            if (k == null || !key.equalsIgnoreCase(k)) continue;
            clazz = Class.forName(propertyElements[i].getAttribute(ATTR_CLASS));
            break;
        }
        return clazz;
    }
}

