/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.model;

import gov.fhie.transformer.commonadapters.message.Field;
import gov.fhie.transformer.commonadapters.message.FieldParser;
import gov.fhie.transformer.hl7adapters.hl7message.HL7Segment;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.transformer.hl7.model.PidSegment;

public abstract class HL7PidSegment
extends HL7Segment
implements PidSegment {
    private static final int IDX_PATIENT_NAME = 5;
    private static final int CIDX_LAST_NAME = 1;
    private static final int CIDX_FIRST_NAME = 2;
    private static final int CIDX_MIDDLE_NAME = 3;
    private static final int CIDX_SUFFIX = 4;
    private static final int IDX_DOB = 7;
    private static final int CIDX_DOB = 1;
    public static final String SEGMENT_TYPE = "PID";
    public static final String SEGMENT_DESC = "HL DG PATIENT IDENTIFICATION";

    public HL7PidSegment(String[] fields, HL7MessageInfo messageInfo) {
        super(messageInfo);
        this.setType(SEGMENT_TYPE);
        this.setDesc(SEGMENT_DESC);
        this.setFieldTypes(this.getTypes());
        this.initSegment(SEGMENT_TYPE, fields);
    }

    public String toString() {
        StringBuffer stringBuf = new StringBuffer(100);
        String delimiter = this.messageInfo.getFieldDelimeter();
        stringBuf.append(this.segmentType);
        for (int i = 0; i < this.segmentFields.length; ++i) {
            stringBuf.append(delimiter);
            Field field = this.segmentFields[i];
            if (field == null) continue;
            stringBuf.append(field.toString());
        }
        return stringBuf.toString();
    }

    protected void initSegment(String segmentName, String[] fields) {
        FieldParser parser = new FieldParser();
        Field[] pidFields = new Field[this.fieldTypes.length];
        for (int i = 1; i < fields.length && i < pidFields.length; ++i) {
            if ("NIL".equals(fields[i])) continue;
            pidFields[i - 1] = parser.getField(this.fieldTypes[i - 1], fields[i], this.messageInfo);
        }
        this.setFields(pidFields);
    }

    public abstract String[] getTypes();

    public String getFirstName() {
        String first = null;
        Field patientName = this.getField(5);
        if (patientName != null) {
            first = patientName.getComponent(2);
        }
        return first;
    }

    public String getMiddleName() {
        String middle = null;
        Field patientName = this.getField(5);
        if (patientName != null) {
            middle = patientName.getComponent(3);
        }
        return middle;
    }

    public String getLastName() {
        String last = null;
        Field patientName = this.getField(5);
        if (patientName != null) {
            last = patientName.getComponent(1);
        }
        return last;
    }

    public String getSuffix() {
        String suffix = null;
        Field patientName = this.getField(5);
        if (patientName != null) {
            suffix = patientName.getComponent(4);
        }
        return suffix;
    }

    public String getDateOfBirth() {
        String birthDate = null;
        Field f = this.getField(7);
        if (f != null) {
            birthDate = f.getComponent(1);
        }
        return birthDate;
    }
}

