/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.model;

import gov.fhie.transformer.commonadapters.message.Field;
import gov.fhie.transformer.commonadapters.message.FieldParser;
import gov.fhie.transformer.hl7adapters.hl7message.HL7Segment;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegment;

public abstract class HL7MshSegment
extends HL7Segment
implements MshSegment {
    public static final String SEGMENT_TYPE = "MSH";
    public static final String SEGMENT_DESC = "HL MESSAGE HEADER OUT";
    public static final int FIELD_SEPARATOR = 1;
    public static final int ENCODING_CHARACTERS = 2;
    public static final int SENDING_APPLICATION = 3;
    public static final int SENDING_FACILITY = 4;
    public static final int RECEIVING_APPLICATION = 5;
    public static final int RECEIVING_FACILITY = 6;
    public static final int MESSAGE_DATETIME = 7;
    public static final int MESSAGE_TYPE = 9;
    public static final int MESSAGE_CONTROL_ID = 10;
    public static final int PROCESSING_ID = 11;
    public static final int VERSION_ID = 12;
    public static final int ACC_ACKNOWLEDGMENT_TYPE = 15;
    public static final int APP_ACKNOWLEDGMENT_TYPE = 16;
    public static final int COUNTRY_CODE = 17;
    public static final int MESSAGE_TYPE_TYPE = 1;
    public static final int TRIGGER_EVENT = 2;
    protected static final int NAMESPACE_ID = 1;
    protected static final int UNIVERSAL_ID = 2;
    protected static final int UNIVERSAL_ID_TYPE = 3;

    public HL7MshSegment(String[] fields, HL7MessageInfo messageInfo) {
        super(messageInfo);
        this.setType(SEGMENT_TYPE);
        this.setDesc(SEGMENT_DESC);
        this.setFieldTypes(this.getTypes());
        this.initSegment(SEGMENT_TYPE, fields);
    }

    public String toString() {
        StringBuffer stringBuf = new StringBuffer(100);
        String delimiter = this.messageInfo.getFieldDelimeter();
        stringBuf.append(this.segmentType);
        for (int i = 1; i < this.segmentFields.length; ++i) {
            stringBuf.append(delimiter);
            Field field = this.segmentFields[i];
            if (field == null) continue;
            stringBuf.append(field.toString());
        }
        return stringBuf.toString();
    }

    public abstract String[] getTypes();

    protected void initSegment(String segmentName, String[] fields) {
        FieldParser parser = new FieldParser();
        Field[] mshFields = new Field[this.fieldTypes.length];
        mshFields[0] = parser.getField(this.fieldTypes[0], this.messageInfo.getFieldDelimeter(), this.messageInfo.getComponentSeparator());
        for (int i = 1; i < fields.length && i < mshFields.length; ++i) {
            if ("NIL".equals(fields[i])) continue;
            mshFields[i] = parser.getField(this.fieldTypes[i], fields[i], this.messageInfo.getComponentSeparator());
        }
        this.setFields(mshFields);
    }

    public char getFieldSeparator() {
        Field f = this.getField(1);
        char fieldSeparator = f != null ? f.getValue().toCharArray()[0] : (char)'\u0000';
        return fieldSeparator;
    }

    public char[] getEncodingCharacters() {
        Field f = this.getField(2);
        char[] encodingCharacters = f != null ? f.getValue().toCharArray() : null;
        return encodingCharacters;
    }

    public String getSendingFacility() {
        Field f = this.getField(4);
        String facilityField = null != f ? f.getValue() : "";
        return facilityField;
    }

    public String getReceivingApplication() {
        Field f = this.getField(5);
        String application = null != f ? f.getValue() : "";
        return application;
    }

    public String getReceivingFacility() {
        Field f = this.getField(6);
        String facilityField = null != f ? f.getValue() : "";
        return facilityField;
    }

    public String getAcceptAcknowledgmentType() {
        Field f = this.getField(15);
        String aat = f != null ? f.getValue() : "";
        return aat;
    }

    public String getApplicationAcknowledgmentType() {
        Field f = this.getField(16);
        String aat = f != null ? f.getValue() : "";
        return aat;
    }

    public String getCountryCode() {
        Field f = this.getField(17);
        String countryCode = f != null ? f.getValue() : "";
        return countryCode;
    }

    public String getMessageControlId() {
        Field f = this.getField(10);
        String messageControlId = f != null ? f.getValue() : null;
        return messageControlId;
    }

    public String getMessageType() {
        String messageType = null;
        Field f = this.getField(9);
        if (f != null) {
            messageType = f.getComponent(1);
        }
        return messageType;
    }

    public String getMessageTypeTriggerEvent() {
        String triggerEvent = null;
        Field f = this.getField(9);
        if (f != null) {
            triggerEvent = f.getComponent(2);
        }
        return triggerEvent;
    }
}

