/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.model;

import gov.fhie.transformer.commonadapters.message.CXField;
import gov.fhie.transformer.commonadapters.message.Field;
import gov.fhie.transformer.commonadapters.message.RepeatingField;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.transformer.hl7.model.HL7PidSegment;
import java.util.StringTokenizer;

public class HL724PidSegment
extends HL7PidSegment {
    private static final int IDX_PATIENT_IDENTIFIER_LIST = 3;
    private static final int CIDX_ID = 1;
    private static final int CIDX_ASSIGNING_AUTHORITY = 4;
    private static final int CIDX_IDENTIFIER_TYPE_CODE = 5;
    private static final int CIDX_ASSIGNING_FACILITY = 6;
    private static final int CIDX_EXPIRATION_DATE = 8;
    private static final int SCIDX_UNIVERSAL_ID = 2;
    private static final String AA_USSSA = "USSSA";
    private static final String[] PID_FIELD_TYPES = new String[]{"SI", "CX", "R-CX", "CX", "XPN", "XPN", "TS", "ST", "XPN", "CE", "XAD", "ST", "XTN", "XTN", "CE", "CE", "CE", "CX", "ST", "DLN", "CX", "CE", "ST", "ID", "NM", "CE", "CE", "CE", "TS", "ID", "ID", "ST", "TS", "ST", "CE", "CE", "ST", "CE"};

    public HL724PidSegment(String[] fields, HL7MessageInfo messageInfo) {
        super(fields, messageInfo);
    }

    public String[] getTypes() {
        return PID_FIELD_TYPES;
    }

    public String getSSN() {
        String ssn = null;
        RepeatingField pidList = (RepeatingField)this.getField(3);
        if (pidList != null) {
            Field[] fields = pidList.getFields();
            CXField field = null;
            String aa = null;
            for (int i = 0; i < fields.length; ++i) {
                field = (CXField)fields[i];
                aa = field.getComponent(4);
                if (aa == null || aa.indexOf(AA_USSSA) == -1) continue;
                ssn = field.getComponent(1);
                break;
            }
        }
        return ssn;
    }

    public String getDomain(String identifierTypeCode) {
        RepeatingField pidList;
        String domain = null;
        if (identifierTypeCode != null && 0 < identifierTypeCode.length() && (pidList = (RepeatingField)this.getField(3)) != null) {
            Field[] fields = pidList.getFields();
            CXField field = null;
            String itc = null;
            String expiration = null;
            for (int i = 0; i < fields.length; ++i) {
                field = (CXField)fields[i];
                itc = field.getComponent(5);
                expiration = field.getComponent(8);
                if (itc == null || !itc.equals(identifierTypeCode) || expiration != null && 0 != expiration.length()) continue;
                domain = field.getComponent(6);
                if (domain == null) break;
                StringTokenizer strTok = new StringTokenizer(domain, this.messageInfo.getSubcomponentSeparator());
                for (int iterationCount = 0; strTok.hasMoreTokens() && iterationCount < 2; ++iterationCount) {
                    domain = strTok.nextToken();
                }
                break;
            }
        }
        return domain;
    }

    public String getDomainId(String identifierTypeCode) {
        RepeatingField pidList;
        String domainId = null;
        if (identifierTypeCode != null && 0 < identifierTypeCode.length() && (pidList = (RepeatingField)this.getField(3)) != null) {
            Field[] fields = pidList.getFields();
            CXField field = null;
            String itc = null;
            String expiration = null;
            for (int i = 0; i < fields.length; ++i) {
                field = (CXField)fields[i];
                itc = field.getComponent(5);
                expiration = field.getComponent(8);
                if (itc == null || !itc.equals(identifierTypeCode) || expiration != null && 0 != expiration.length()) continue;
                domainId = field.getComponent(1);
                break;
            }
        }
        return domainId;
    }
}

