/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.mapping.xml;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.util.RegularExpressionHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParser;
import gov.va.med.hds.hdr.transformer.hl7.mapping.IdentityRegistry;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MapInfo;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MapKey;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MappingFileMapInfo;
import gov.va.med.hds.hdr.transformer.hl7.mapping.TokenMapper;
import gov.va.med.hds.hdr.transformer.template.TemplateBuilderHelper;
import gov.va.med.hds.hdr.transformer.template.TemplateBuildingException;
import gov.va.med.hds.hdr.transformer.template.XMLTemplateBuilderDelegate;
import java.util.Hashtable;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.Element;

public class TemplateXMLTokenMapper
implements TokenMapper {
    private HL7MessageParser parser = null;
    private HL7MessageInfo messageInfo = null;
    private IdentityRegistry identityRegistry = null;
    private Document model = null;
    protected TemplateBuilderHelper templateBuilderHelper = null;
    private Map<String, Boolean> matchesMap = new Hashtable<String, Boolean>();

    public TemplateXMLTokenMapper(IdentityRegistry identityRegistry, Document model, HL7MessageParser parser, HL7MessageInfo messageInfo) {
        this.setIdentityRegistry(identityRegistry);
        this.setModel(model);
        this.templateBuilderHelper = new TemplateBuilderHelper(new XMLTemplateBuilderDelegate());
        this.parser = parser;
        this.messageInfo = messageInfo;
    }

    public void mapToken(MapKey mapKey, Object data) {
        if (data == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " requires object data to be non-null.");
        }
        String mapData = data.toString();
        MapInfo[] mapInfos = this.identityRegistry.getMapInfos(mapKey);
        MappingFileMapInfo mapInfo = null;
        String[] mappingLine = null;
        for (int i = 0; i < mapInfos.length; ++i) {
            mapInfo = (MappingFileMapInfo)mapInfos[i];
            mappingLine = mapInfo.getMappingLine();
            String path = mappingLine[10];
            Element attribute = null;
            boolean createDomainValue = "1".equals(mappingLine[15]);
            boolean createInstance = "1".equals(mappingLine[16]);
            boolean append = "1".equals(mappingLine[4]);
            int separator = Integer.parseInt(mappingLine[5]);
            String attrNum = mappingLine[8];
            String fieldName = mappingLine[12];
            String fieldRegEx = mappingLine[9];
            String type = mappingLine[11];
            try {
                if (!"NIL".equals(fieldRegEx) && !this.matches(this.messageInfo, this.parser.getCurrentField(), fieldRegEx)) continue;
                attribute = (Element)this.templateBuilderHelper.getAttribute(this.model.getRootElement(), path, type, createInstance, createDomainValue);
                this.templateBuilderHelper.setFieldText(attribute, fieldName, mapData, append, (char)separator);
                continue;
            }
            catch (TemplateBuildingException e) {
                throw IMSException.getIMSException("An error occurred while building the domain value for the logical model.", e);
            }
        }
    }

    public IdentityRegistry getIdentityRegistry() {
        return this.identityRegistry;
    }

    public void setIdentityRegistry(IdentityRegistry identityRegistry) {
        if (identityRegistry == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " requires object identity registry to be non-null");
        }
        this.identityRegistry = identityRegistry;
    }

    public Document getModel() {
        return this.model;
    }

    public void setModel(Document model) {
        if (model == null || !(model instanceof Document)) {
            throw new IllegalArgumentException(this.getClass().getName() + " requires object model to be non-null and of type " + Document.class.getName());
        }
        this.model = model;
    }

    private boolean matches(HL7MessageInfo messageInfo, String field, String regEx) {
        String key = field + regEx;
        Boolean matches = this.matchesMap.get(key);
        if (matches == null) {
            regEx = RegularExpressionHelper.genericToMessageSpecific(messageInfo, regEx);
            matches = new Boolean(field.matches(regEx));
            this.matchesMap.put(key, matches);
        }
        return matches;
    }
}

