/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.mapping.reflection;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.transformer.hl7.mapping.IdentityRegistry;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MapInfo;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MapKey;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MappingFileMapInfo;
import gov.va.med.hds.hdr.transformer.hl7.mapping.TokenMapper;
import gov.va.med.hds.hdr.transformer.template.ReflectionObjectBuilderDelegate;
import gov.va.med.hds.hdr.transformer.template.TemplateBuilderHelper;
import gov.va.med.hds.hdr.transformer.template.TemplateBuildingException;

public class ObjectTokenMapper
implements TokenMapper {
    private Object template;
    private String templateName;
    private IdentityRegistry identityRegistry;
    private TemplateBuilderHelper templateBuilderHelper;

    public ObjectTokenMapper(String templateName, IdentityRegistry identityRegistry, Object template) throws Exception {
        if (identityRegistry == null) {
            throw new IllegalArgumentException(ObjectTokenMapper.class.getName() + " requires the identity registry parameter to be non-null.");
        }
        this.identityRegistry = identityRegistry;
        this.templateName = templateName;
        this.template = template;
        this.templateBuilderHelper = new TemplateBuilderHelper(new ReflectionObjectBuilderDelegate());
    }

    public void mapToken(MapKey mapKey, Object data) {
        if (data == null) {
            throw new IllegalArgumentException(this.getClass().getName() + " requires object data to be non-null.");
        }
        String mapData = data.toString();
        MapInfo[] mapInfos = this.identityRegistry.getMapInfos(mapKey);
        MappingFileMapInfo mapInfo = null;
        String[] mappingLine = null;
        for (int i = 0; i < mapInfos.length; ++i) {
            mapInfo = (MappingFileMapInfo)mapInfos[i];
            mappingLine = mapInfo.getMappingLine();
            String path = mappingLine[10];
            boolean createInstance = "1".equals(mappingLine[16]);
            boolean createAttribute = "1".equals(mappingLine[15]);
            boolean append = "1".equals(mappingLine[4]);
            int separator = Integer.parseInt(mappingLine[5]);
            String attrNum = mappingLine[8];
            String fieldName = mappingLine[12];
            String fieldRegEx = mappingLine[9];
            String type = mappingLine[11];
            String sourceType = mappingLine[7];
            try {
                Object attribute = this.templateBuilderHelper.getAttribute(this.template, path, type, createInstance, createAttribute);
                this.templateBuilderHelper.setFieldText(attribute, fieldName, sourceType, mapData, append, (char)separator);
                continue;
            }
            catch (TemplateBuildingException tbe) {
                throw IMSException.getIMSException("Error build object graph.", tbe);
            }
        }
    }
}

