/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.hl7.mapping;

import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParser;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserEvent;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserListener;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.hl7.mapping.IdentityRegistry;
import gov.va.med.hds.hdr.transformer.hl7.mapping.MapKey;
import gov.va.med.hds.hdr.transformer.hl7.mapping.SegmentInfo;
import gov.va.med.hds.hdr.transformer.hl7.mapping.TokenMapper;
import java.util.Hashtable;
import java.util.Map;

public class HL7DataMappingContext
implements HL7MessageParserListener {
    private ResultAdapter resultAdapter = null;
    private String modelIdentifier = null;
    private String messageType = null;
    private HL7MessageInfo messageInfo = null;
    private String segmentName = null;
    private String segmentGroup = "Root";
    private Object model = null;
    private HL7MessageParser parser;
    protected IdentityRegistry identityRegistry = null;
    protected TokenMapper tokenMapper = null;
    protected static Map FILTER_MAP = new Hashtable();

    public HL7DataMappingContext(ResultAdapter resultAdapter, String modelIdentifier, String messageType, HL7MessageInfo messageInfo, HL7MessageParser parser, Object model, IdentityRegistry identityRegistry, TokenMapper tokenMapper) {
        this.resultAdapter = resultAdapter;
        this.modelIdentifier = modelIdentifier;
        this.messageType = messageType;
        this.messageInfo = messageInfo;
        this.parser = parser;
        this.model = model;
        this.identityRegistry = identityRegistry;
        this.tokenMapper = tokenMapper;
    }

    private void mapValue(HL7MessageParserEvent event) {
        this.resultAdapter.executeTokenFilters(this.segmentName, event);
        MapKey key = this.identityRegistry.identifyToken(this.modelIdentifier, this.messageInfo, this.messageType, this.segmentName, event.getFieldIndex(), event.getComponentIndex(), event.getSubcomponentIndex());
        if (key != null) {
            this.tokenMapper.mapToken(key, event.getText());
        }
    }

    public HL7MessageInfo getMessageInfo() {
        return this.messageInfo;
    }

    public void setMessageInfo(HL7MessageInfo messageInfo) {
        this.messageInfo = messageInfo;
    }

    public String getSegmentGroup() {
        return this.segmentGroup;
    }

    public void setSegmentGroup(String currentGroup) {
        this.segmentGroup = currentGroup;
    }

    public void beginSegment(HL7MessageParserEvent event) {
        this.segmentName = null;
        String segmentText = this.parser.getCurrentSegment();
        SegmentInfo segmentInfo = this.identityRegistry.identifySegment(this.messageInfo, this.messageType, event.getSegmentName(), this.getSegmentGroup(), segmentText);
        if (segmentInfo != null) {
            if (segmentInfo.isNewGroup()) {
                this.setSegmentGroup(segmentInfo.getSegmentName());
            } else if (segmentInfo.isEndGroup()) {
                this.setSegmentGroup(segmentInfo.getGroupName());
            }
            this.segmentName = segmentInfo.getSegmentName();
        }
    }

    public void endSegment(HL7MessageParserEvent event) {
    }

    public void beginField(HL7MessageParserEvent event) {
    }

    public void repeatField(HL7MessageParserEvent event) {
        this.mapValue(event);
    }

    public void endField(HL7MessageParserEvent event) {
        this.mapValue(event);
    }

    public void beginComponent(HL7MessageParserEvent event) {
    }

    public void endComponent(HL7MessageParserEvent event) {
        this.mapValue(event);
    }

    public void beginSubcomponent(HL7MessageParserEvent event) {
    }

    public void endSubcomponent(HL7MessageParserEvent event) {
        this.mapValue(event);
    }
}

