/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.collector;

import gov.fhie.common.properties.ApplicationConfigurationException;
import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.transformer.collector.ObservationCollector;
import java.lang.reflect.Constructor;
import org.dom4j.Element;

public class ObservationCollectorFactory {
    private static final String XP_OBSCOLL = "observation-collectors/observation-collector/template[@name='TEMPLATE_NAME']";
    private static ObservationCollectorFactory instance = null;

    private ObservationCollectorFactory() {
    }

    public static ObservationCollectorFactory getInstance() throws Exception {
        if (instance == null) {
            instance = new ObservationCollectorFactory();
        }
        return instance;
    }

    public ObservationCollector createObservationCollector(String domain, String template, AdapterFactory adapterFactory) throws Exception {
        String xpath;
        PropertyMgr pm = PropertyMgr.getInstance(domain);
        PropertyElement templateElement = pm.getProperty(xpath = XP_OBSCOLL.replaceFirst("TEMPLATE_NAME", template));
        Element te = templateElement.getElement();
        if (te != null) {
            Element ocElement = templateElement.getElement().getParent();
            Class<?> clazz = Class.forName(ocElement.attributeValue("class"));
            Constructor<?> c = clazz.getConstructor(String.class, AdapterFactory.class);
            return (ObservationCollector)c.newInstance(domain, adapterFactory);
        }
        throw new ApplicationConfigurationException("There is no observation configured for template '" + template + "' in the " + domain + " domain.");
    }
}

