/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.collector;

import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.busobj.vhim.lab.LabTest;
import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.dao.DAOFactory;
import gov.va.med.hds.hdr.service.dao.LaboratoryDAO;
import gov.va.med.hds.hdr.service.dao.PatientDAO;
import gov.va.med.hds.hdr.transformer.collector.DefaultObservationCollector;
import java.util.Collection;
import java.util.Set;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LaboratoryObservationCollector
extends DefaultObservationCollector {
    public LaboratoryObservationCollector(String domain, AdapterFactory adapterFactory) {
        super(domain, adapterFactory);
    }

    @Override
    public void getObservations(Collection<Object> observations, PatientIdentifier pid, String template, String rangeStart, String rangeEnd, String requestingFacility) throws Exception {
        DAOFactory factory = ServiceLocator.getInstance().getDAOFactory(template);
        LaboratoryDAO dao = factory.createLaboratoryDAO();
        PatientDAO patientDao = ServiceLocator.getInstance().getDAOFactory().createPatientDAO();
        PatientIdentifier cid = patientDao.getCorreledId(pid, this.getDomain());
        PatientIdentifier nid = patientDao.findNationalIdByPatientId(pid, cid.getDomain());
        Set<LabTest> labTests = dao.findLabTests(pid, rangeStart, rangeEnd);
        Adapter adapter = this.adapterFactory.createAdapter();
        for (LabTest labTest : labTests) {
            adapter.setInput(labTest);
            adapter.adapt();
            observations.add(adapter.getResult());
        }
    }
}

