/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.collector;

import gov.fhie.transformer.hl7adapters.hl7repository.HL7RepositoryWrapper;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.transformer.collector.ObservationCollector;
import gov.va.med.hds.hdr.transformer.hl7adapters.hl7repository.HL7Message;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultObservationCollector
implements ObservationCollector {
    private String domain = null;
    protected AdapterFactory adapterFactory = null;

    public DefaultObservationCollector(String domain, AdapterFactory adapterFactory) {
        this.setDomain(domain);
        this.setAdapterFactory(adapterFactory);
    }

    @Override
    public void getObservations(Collection<Object> observations, PatientIdentifier pid, String template, String rangeStart, String rangeEnd, String requestingFacility) throws Exception {
        HL7Message[] messages = this.getMessages(pid, template, rangeStart, rangeEnd, requestingFacility);
        Adapter adapter = this.adapterFactory.createAdapter();
        for (int i = 0; i < messages.length; ++i) {
            adapter.setInput(messages[i]);
            adapter.adapt();
            observations.add(adapter.getResult());
        }
    }

    protected HL7Message[] getMessages(PatientIdentifier pid, String template, String rangeStart, String rangeStop, String requestingFacility) throws Exception {
        HL7RepositoryWrapper repo = new HL7RepositoryWrapper(this.getDomain());
        return repo.getMessages(template, pid);
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }

    protected AdapterFactory getAdapterFactory() {
        return this.adapterFactory;
    }

    protected void setAdapterFactory(AdapterFactory adapterFactory) {
        this.adapterFactory = adapterFactory;
    }
}

