/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.adapter.hl7er7;

import gov.fhie.transformer.commonadapters.resultsadapter.MappingInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParser;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserListener;
import gov.va.med.hds.hdr.hl7.parser.MessageParserException;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterException;
import gov.va.med.hds.hdr.transformer.adapter.hl7er7.DefaultResultAdapter;
import gov.va.med.hds.hdr.transformer.hl7.mapping.HL7DataMappingContext;
import gov.va.med.hds.hdr.transformer.hl7.mapping.xml.TemplateXMLTokenMapper;
import gov.va.med.hds.hdr.transformer.hl7.parser.tokenfilter.PatientIdentifierTypeCodeFilter;
import gov.va.med.hds.hdr.transformer.hl7.parser.tokenfilter.PatientSiteQualifierTokenFilter;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class PatientResultAdapter
extends DefaultResultAdapter {
    private String templateTypeCode = null;
    private HL7MessageInfo messageInfo = null;

    public PatientResultAdapter() {
        this.templateTypeCode = "PATIENT";
    }

    public PatientResultAdapter(String templateTypeCode, HL7MessageInfo messageInfo) {
        this.templateTypeCode = templateTypeCode;
        this.messageInfo = messageInfo;
    }

    public Object adapt(String message, String templateName) throws ResultAdapterException {
        long startTime = System.currentTimeMillis();
        try {
            if (this.messageInfo == null) {
                this.messageInfo = new HL7MessageInfoImpl(message);
            }
            Document document = DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)"graph"));
            this.parser = new HL7MessageParser(message);
            this.mappingContext = new HL7DataMappingContext(this, templateName, this.templateTypeCode, this.messageInfo, this.parser, document, MappingInfo.getInstance(), new TemplateXMLTokenMapper(MappingInfo.getInstance(), document, this.parser, this.messageInfo));
            this.initTokenFilters();
            this.parser.addParserEventListener((HL7MessageParserListener)this.mappingContext);
            document.getRootElement().addAttribute("templateName", templateName);
            this.parser.parseMessage();
            return document;
        }
        catch (MessageParserException mpe) {
            throw new ResultAdapterException("An error was encountered while parsing the message.", mpe);
        }
    }

    protected void initTokenFilters() {
        PatientIdentifierTypeCodeFilter identifierTypeCodeFilter = new PatientIdentifierTypeCodeFilter();
        this.tokenFilters.add(identifierTypeCodeFilter);
        this.tokenFilters.add(new PatientSiteQualifierTokenFilter(identifierTypeCodeFilter));
    }
}

