/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.adapter.hl7er7;

import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.commonadapters.resultsadapter.MappingInfo;
import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentParser;
import gov.va.med.hds.hdr.common.util.RegularExpressionHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.hl7.parser.EscapeSequenceHandler;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParser;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserEvent;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserListener;
import gov.va.med.hds.hdr.hl7.parser.MessageParserException;
import gov.va.med.hds.hdr.hl7.parser.XMLEscapeSequenceHandler;
import gov.va.med.hds.hdr.hl7.parser.tokenfilter.HL7ParserTokenFilter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterException;
import gov.va.med.hds.hdr.transformer.hl7.mapping.HL7DataMappingContext;
import gov.va.med.hds.hdr.transformer.hl7.mapping.xml.TemplateXMLTokenMapper;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;

public class DefaultResultAdapter
implements ResultAdapter {
    private static final String XP_TYPE_CODE = "transformer/mapping-type-codes/mapping-type-code[@template='TEMPLATE_NAME' and @message-type='MESSAGE_TYPE']/@type-code";
    public String sendingFacility = "";
    protected HL7DataMappingContext mappingContext;
    protected HL7MessageParser parser;
    protected List<Object> tokenFilters = new ArrayList<Object>();

    public Object adapt(String message, String templateName) throws ResultAdapterException {
        long startTime = System.currentTimeMillis();
        try {
            Document document = DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)"graph"));
            String templateTypeCode = this.getTemplateTypeCode(templateName, message);
            HL7MessageInfoImpl messageInfo = new HL7MessageInfoImpl(message);
            this.parser = new HL7MessageParser(message);
            String resolvedTemplate = templateName.split("~", 2)[0];
            this.mappingContext = new HL7DataMappingContext(this, resolvedTemplate, templateTypeCode, (HL7MessageInfo)messageInfo, this.parser, document, MappingInfo.getInstance(), new TemplateXMLTokenMapper(MappingInfo.getInstance(), document, this.parser, (HL7MessageInfo)messageInfo));
            this.initTokenFilters();
            this.parser.addParserEventListener((HL7MessageParserListener)this.mappingContext);
            this.parser.addEscapeSequenceHandler((EscapeSequenceHandler)new XMLEscapeSequenceHandler());
            document.getRootElement().addAttribute("templateName", resolvedTemplate);
            this.parser.parseMessage();
            return document;
        }
        catch (MessageParserException mpe) {
            throw new ResultAdapterException("An error was encountered while parsing the message.", mpe);
        }
    }

    public String getMessageType(String rawMessage) throws ResultAdapterException {
        long startTime = System.currentTimeMillis();
        StringBuffer sbMessageType = new StringBuffer();
        HL7MessageInfoImpl messageInfo = new HL7MessageInfoImpl(rawMessage);
        String segment = DefaultResultAdapter.getFirstSegmentOccurence(rawMessage, "MSH");
        if (segment != null && segment.length() != 0) {
            String[] fields = HL7SegmentParser.parseLine(segment, (HL7MessageInfo)messageInfo);
            String[] msgType = fields[8].split(RegularExpressionHelper.escape(messageInfo.getComponentSeparator()));
            sbMessageType.append(fields[2]).append('_').append(msgType[0]).append('_').append(msgType[1]);
        }
        return sbMessageType.toString();
    }

    protected void initTokenFilters() {
    }

    protected String getTemplateTypeCode(String templateName, String message) throws ResultAdapterException {
        String messageType = this.getMessageType(message);
        PropertyMgr pm = PropertyMgr.getInstance();
        String xPath = XP_TYPE_CODE.replaceFirst("MESSAGE_TYPE", messageType);
        xPath = xPath.replaceFirst("TEMPLATE_NAME", templateName);
        return pm.getProperty(xPath).getValue();
    }

    public void executeTokenFilters(String segmentName, HL7MessageParserEvent event) {
        String tokenKey = segmentName + "-" + event.getFieldIndex() + "." + event.getComponentIndex() + "." + event.getSubcomponentIndex();
        for (int i = 0; i < this.tokenFilters.size(); ++i) {
            HL7ParserTokenFilter tf = (HL7ParserTokenFilter)this.tokenFilters.get(i);
            if (!tf.getTokenFilterKey().equals(tokenKey)) continue;
            tf.applyFilter(segmentName, event);
        }
    }

    public static String getFirstSegmentOccurence(String rawMessage, String segmentType) {
        HL7MessageInfoImpl messageInfo = new HL7MessageInfoImpl(rawMessage);
        StringTokenizer strTok = new StringTokenizer(rawMessage, HL7MessageInfo.LINE_DELIMETER);
        String segment = "";
        while (strTok.hasMoreTokens() && !segment.startsWith(segmentType)) {
            segment = strTok.nextToken();
        }
        return segment;
    }

    public static int getSegmentCount(String rawMessage, String segmentType) {
        String[] strarr = rawMessage.split(segmentType);
        return strarr.length - 1;
    }
}

