/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.adapter.hl7er7;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentParser;
import gov.va.med.hds.hdr.common.util.RegularExpressionHelper;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.hl7.parser.HL7MessageParserEvent;
import gov.va.med.hds.hdr.mapping.da.DirectAccessTemplateBuilder;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterException;
import java.io.File;
import java.io.FilenameFilter;
import java.util.HashMap;
import java.util.Map;
import org.springframework.beans.factory.config.ConfigurableListableBeanFactory;
import org.springframework.beans.factory.config.CustomEditorConfigurer;
import org.springframework.beans.factory.xml.XmlBeanFactory;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.Resource;

public class DAHL72ObjectGraphResultAdapter
implements ResultAdapter {
    private static String XP_MAPPING_DIR = "transformer/mapping-files-dir";
    private static Map<String, DirectAccessTemplateBuilder> BUILDER_MAP = new HashMap<String, DirectAccessTemplateBuilder>();

    public Object adapt(String message, String templateName) throws ResultAdapterException {
        DirectAccessTemplateBuilder builder = DAHL72ObjectGraphResultAdapter.getBuilder(templateName);
        return builder.buildTemplate(message);
    }

    private static synchronized DirectAccessTemplateBuilder getBuilder(String templateName) throws ResultAdapterException {
        DirectAccessTemplateBuilder builder = BUILDER_MAP.get(templateName);
        if (builder == null) {
            builder = DAHL72ObjectGraphResultAdapter.loadBuilder(templateName);
            BUILDER_MAP.put(templateName, builder);
        }
        return builder;
    }

    private static DirectAccessTemplateBuilder loadBuilder(String templateName) throws ResultAdapterException {
        PropertyMgr pmgr = PropertyMgr.getInstance();
        String[] arr = templateName.split("/");
        if (arr.length != 2) {
            throw new ResultAdapterException("Could not load builder object. Reason: Invalid template name.");
        }
        final String template = arr[1];
        PropertyElement pe = pmgr.getProperty(XP_MAPPING_DIR);
        if (pe == null) {
            throw new ResultAdapterException("Could not load builder object. Reason: Application properties does not include properly configured mapping file directory. Fix application configuration before continuing.");
        }
        File dir = new File(pe.getValue());
        String[] appCtxts = null;
        if (dir.isDirectory()) {
            appCtxts = dir.list(new FilenameFilter(){

                public boolean accept(File dir, String fileName) {
                    return fileName.startsWith(template) && fileName.endsWith("application-context.xml");
                }
            });
        }
        if (appCtxts == null || appCtxts.length > 1) {
            throw new ResultAdapterException("More than one application context file for template with name " + templateName);
        }
        DirectAccessTemplateBuilder builder = null;
        try {
            XmlBeanFactory factory = new XmlBeanFactory((Resource)new FileSystemResource(new File(dir, appCtxts[0])));
            CustomEditorConfigurer config = (CustomEditorConfigurer)factory.getBean("customEditorConfigurer");
            config.postProcessBeanFactory((ConfigurableListableBeanFactory)factory);
            builder = (DirectAccessTemplateBuilder)factory.getBean("templateBuilder");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return builder;
    }

    public String getMessageType(String rawMessage) throws ResultAdapterException {
        HL7MessageInfoImpl messageInfo = new HL7MessageInfoImpl(rawMessage);
        String segment = rawMessage.split("\r")[0];
        if (segment != null && segment.length() != 0) {
            String[] fields = HL7SegmentParser.parseLine(segment, (HL7MessageInfo)messageInfo);
            String[] msgType = fields[8].split(RegularExpressionHelper.escape(messageInfo.getComponentSeparator()));
            return new StringBuffer().append(fields[2]).append('_').append(msgType[0]).append('_').append(msgType[1]).toString();
        }
        throw new ResultAdapterException("Raw HL7 message provided is invalid.");
    }

    public void executeTokenFilters(String segmentName, HL7MessageParserEvent event) {
    }
}

