/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.transformer.adapter;

import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentParser;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapter;
import gov.va.med.hds.hdr.transformer.adapter.ResultAdapterException;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegment;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegmentFactory;

public class ResultAdapterFactory {
    private static final String XP_RESULT_ADAPTER = "transformer/resultadapters/resultadapter[@sendingapp='SENDING_APP']/@adapter";

    private ResultAdapterFactory() {
    }

    public static ResultAdapter createResultAdapter(String message) throws ResultAdapterException {
        HL7MessageInfoImpl messageInfo;
        long startTime = System.currentTimeMillis();
        ResultAdapter resultAdapter = null;
        int ldIdx = -1;
        String headerSegment = null;
        if (message == null || message.length() == 0 || (ldIdx = message.indexOf(HL7MessageInfo.LINE_DELIMETER)) == -1) {
            throw new ResultAdapterException("An error occured while creating the result adapter. The message passed in as a parameter is invalid.\n\tMessage:" + message);
        }
        headerSegment = message.substring(0, ldIdx);
        String[] fields = HL7SegmentParser.parseLine(headerSegment, (HL7MessageInfo)(messageInfo = new HL7MessageInfoImpl(message)));
        MshSegment mshSegment = MshSegmentFactory.createSegment(fields, (HL7MessageInfo)messageInfo);
        if (null == mshSegment) {
            throw new ResultAdapterException("An error occured while creating the result adapter. The message passed in as a parameter is invalid.\n\tMessage:" + message);
        }
        String sendingApp = mshSegment.getSendingApplicationNamespaceId();
        resultAdapter = ResultAdapterFactory.getResultAdapter(sendingApp);
        if (resultAdapter == null) {
            throw new ResultAdapterException("The result adapter for " + sendingApp + " was not found. Please check configuration " + "file for errors.");
        }
        return resultAdapter;
    }

    private static ResultAdapter getResultAdapter(String sendingApp) throws ResultAdapterException {
        String xpath;
        ResultAdapter resultAdapter = null;
        PropertyMgr pmgr = PropertyMgr.getInstance();
        String className = pmgr.getProperty(xpath = XP_RESULT_ADAPTER.replaceFirst("SENDING_APP", sendingApp)).getValue();
        if (className != null && className.length() > 0) {
            try {
                resultAdapter = (ResultAdapter)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new ResultAdapterException("An error occurred when instantiating result adapter of type " + className + ".", e);
            }
        } else {
            throw new ResultAdapterException("There is no result adapter configuration for the sending applicaiton ('" + sendingApp + "').");
        }
        return resultAdapter;
    }
}

