/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.rules.drools;

import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.common.util.ExceptionList;
import gov.va.med.hds.hdr.service.rules.RulesEngine;
import gov.va.med.hds.hdr.service.rules.RulesEngineInitializationException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import org.drools.FactException;
import org.drools.RuleBase;
import org.drools.WorkingMemory;
import org.drools.io.RuleBaseLoader;
import org.drools.semantics.base.BooleanSemaphore;
import org.drools.spi.AgendaFilter;
import org.drools.spi.RuleNameStartsWithAgendaFilter;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DroolsRulesEngine
implements RulesEngine {
    private static final String SYSPROP_RULES = "ims.rules";
    private static DroolsRulesEngine instance = new DroolsRulesEngine();
    private String rulesFile = "/hdrims-rules.drl";
    private RuleBase rules = null;

    private DroolsRulesEngine() {
        try {
            this.loadFrameworkRules();
        }
        catch (RulesEngineInitializationException e) {
            throw IMSException.getIMSException("An error was encountered while loading the HDR-IMS rules-engine rules.", e);
        }
    }

    public static final RulesEngine getInstance() {
        return instance;
    }

    private void loadFrameworkRules() throws RulesEngineInitializationException {
        String rulesSystemProperty = System.getProperty(SYSPROP_RULES);
        if (rulesSystemProperty != null) {
            this.rulesFile = rulesSystemProperty;
        }
        try {
            this.rules = RuleBaseLoader.loadFromUrl((URL)this.getClass().getResource(this.rulesFile));
        }
        catch (Exception e) {
            throw new RulesEngineInitializationException(e);
        }
    }

    @Override
    public boolean reprocessErroredMessage(Exception e) {
        BooleanSemaphore retVal = new BooleanSemaphore("reprocess");
        retVal.setValue(true);
        WorkingMemory workingMemory = this.rules.newWorkingMemory();
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        try {
            String stackTrace = sw.getBuffer().toString();
            workingMemory.assertObject((Object)stackTrace);
            workingMemory.assertObject((Object)retVal);
            workingMemory.fireAllRules((AgendaFilter)new RuleNameStartsWithAgendaFilter("Reprocess Message:"));
        }
        catch (FactException fe) {
            IMSException.getIMSException("An error occurred while evaluating rules for reprocess error message.", fe);
        }
        return retVal.getValue();
    }

    @Override
    public String[] getErrorMessages(Exception e) {
        WorkingMemory workingMemory = this.rules.newWorkingMemory();
        String[] msgs = null;
        List<StackTraceElement> stackTraceElements = DroolsRulesEngine.getStackTraceElementList(e, new ArrayList<StackTraceElement>());
        ArrayList messages = new ArrayList();
        try {
            workingMemory.assertObject(stackTraceElements);
            workingMemory.assertObject(messages);
            workingMemory.fireAllRules((AgendaFilter)new RuleNameStartsWithAgendaFilter("Error Messages:"));
            msgs = messages.toArray(new String[0]);
        }
        catch (FactException fe) {
            IMSException.getIMSException("An error occurred while getting error messages from exception.", fe);
        }
        return msgs;
    }

    private static List<StackTraceElement> getStackTraceElementList(Throwable t, List<StackTraceElement> l) {
        if (t == null) {
            return l;
        }
        if (t instanceof ExceptionList) {
            List causes = ((ExceptionList)t).getCauses();
            Iterator iter = causes.iterator();
            while (iter.hasNext()) {
                l = DroolsRulesEngine.getStackTraceElementList((Throwable)iter.next(), l);
            }
        } else {
            l.addAll(Arrays.asList(t.getStackTrace()));
            l = DroolsRulesEngine.getStackTraceElementList(t.getCause(), l);
        }
        return l;
    }
}

