/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.queryaccess;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.domain.DataDomain;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocator;
import gov.va.med.hds.hdr.busobj.domain.DataDomainLocatorException;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.common.adapter.AdapterFactory;
import gov.va.med.hds.hdr.common.util.ExceptionList;
import gov.va.med.hds.hdr.service.queryaccess.ClinicalQueryAccess;
import gov.va.med.hds.hdr.service.queryaccess.PatientNotKnownException;
import gov.va.med.hds.hdr.service.queryaccess.QueryAccessException;
import java.util.Collection;

public class ClinicalQueryAccessImpl
implements ClinicalQueryAccess {
    private static PropertyMgr propertyMgr = PropertyMgr.getInstance();
    private String originatingDomain = null;

    public Collection getPatientObservations(String icn, String what, String startDate, String stopDate, String requestingFacility, AdapterFactory adapterFactory) throws QueryAccessException {
        DataDomain dataDomain;
        if (this.originatingDomain == null) {
            throw new QueryAccessException("The clinical query access object must be initialized with a valid originating domain prior to requesting data from it.");
        }
        ClinicalQueryAccessImpl.validateTimespan(startDate, stopDate);
        if (!this.isSupportedTemplate(what)) {
            throw IMSException.getIMSException(new QueryAccessException("The template '" + what + "' is not supported by the domain '" + this.originatingDomain + "'. " + "Please check the application configuration for " + "the domain and retry the query."));
        }
        try {
            dataDomain = DataDomainLocator.getInstance().locate(this.originatingDomain);
        }
        catch (DataDomainLocatorException e1) {
            throw new QueryAccessException("An error occurred while trying to locate the DataDomain object for the domain: " + this.originatingDomain + ".", e1);
        }
        Collection<Object> c = null;
        ExceptionList exl = new ExceptionList();
        try {
            c = dataDomain.collectObservations(new PatientIdentifier(this.getNationalIdDomain(), icn, "A"), what, startDate, stopDate, requestingFacility, adapterFactory, exl);
        }
        catch (gov.va.med.hds.hdr.busobj.domain.PatientNotKnownException pnke) {
            if (exl.getExceptionCount() == 0) {
                throw new PatientNotKnownException();
            }
            exl.addCause(new PatientNotKnownException());
        }
        catch (Exception e2) {
            exl.addCause(e2);
        }
        if (exl.getExceptionCount() != 0) {
            throw new QueryAccessException("An error occurred while collecting observations for patient.", exl);
        }
        return c;
    }

    private boolean isSupportedTemplate(String template) {
        boolean retVal = false;
        PropertyMgr pm = PropertyMgr.getInstance(this.originatingDomain);
        PropertyElement[] supportedCodes = pm.getProperties("frameworkcoas/supported_code");
        for (int i = 0; i < supportedCodes.length; ++i) {
            if (!supportedCodes[i].getValue().equals(template)) continue;
            retVal = true;
            break;
        }
        return retVal;
    }

    public static void validateTimespan(String start, String end) throws QueryAccessException {
        String currTime = DateTimeUtility.getCurrentTime();
        if (!DateTimeUtility.validateISOTime(start)) {
            throw new QueryAccessException("The start time ( " + start + " ) is invalid.");
        }
        if (!DateTimeUtility.validateISOTime(end)) {
            throw new QueryAccessException("The end time ( " + end + " ) is invalid.");
        }
        if (start.compareTo(end) > 0) {
            throw new QueryAccessException("The starting time ( " + start + " ) cannot be later that the ending time ( " + end + " ).");
        }
    }

    public String getOriginatingDomain() {
        return this.originatingDomain;
    }

    public void setOriginatingDomain(String originatingDomain) {
        this.originatingDomain = originatingDomain;
    }

    private String getNationalIdDomain() {
        return propertyMgr.getProperty("transformer/national-id-domain").getValue();
    }
}

