/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.mpi.stub;

import gov.fhie.common.logger.ErrorCode;
import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.xslt.XSLTAdapterFactory;
import gov.va.med.hds.hdr.common.util.Checksum;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.dao.HL7AuditDAO;
import gov.va.med.hds.hdr.service.mpi.MPIException;
import gov.va.med.hds.hdr.service.mpi.MasterPatientIndex;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Properties;
import javax.jms.BytesMessage;
import javax.jms.JMSException;
import javax.jms.Message;
import javax.jms.Session;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;
import org.springframework.jms.core.MessageCreator;

public class MpiStubClient
implements MasterPatientIndex {
    private Properties properties = null;

    public MpiStubClient(Properties props) throws MPIException {
        if (props == null) {
            throw new MPIException("The class must be initialized with a non-null java.util.Properties object.");
        }
        this.properties = props;
    }

    public void correlatePatient(String domain, Patient patient) throws MPIException {
        long start = System.currentTimeMillis();
        PatientIdentifier icn = null;
        PatientIdentifier nid = patient.getFirstIdentifier(2);
        PatientIdentifier lid = patient.getFirstIdentifier(3);
        if (nid != null) {
            icn = nid;
        } else if (lid != null) {
            String dummyIcn = Checksum.addChecksumToIcn(lid.getId());
            icn = new PatientIdentifier("FHIE.GOV/VA0", dummyIcn);
            patient.addIdentifier(icn, 2);
        }
        if (icn != null) {
            Document mpi = DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)"mpi"));
            String msgDateTime = DateTimeUtility.getCurrentTime();
            Element dateTime = DocumentHelper.createElement((String)"messageDateTime");
            dateTime.setText(msgDateTime);
            mpi.getRootElement().add(dateTime);
            Element sendingFacility = DocumentHelper.createElement((String)"sendingFacility");
            sendingFacility.setText(this.properties.getProperty("sendingFacility"));
            mpi.getRootElement().add(sendingFacility);
            Element receivingFacility = DocumentHelper.createElement((String)"receivingFacility");
            receivingFacility.setText(this.properties.getProperty("receivingFacility"));
            mpi.getRootElement().add(receivingFacility);
            Element patientElement = (Element)patient.getXmlDocument().getRootElement().clone();
            mpi.getRootElement().add(patientElement);
            String requestTemplate = null;
            String responseTemplate = null;
            if (lid != null && this.isLinkPatient(lid)) {
                requestTemplate = this.properties.getProperty("template-linkpatientreq");
                responseTemplate = this.properties.getProperty("template-linkpatientresp");
            } else {
                requestTemplate = this.properties.getProperty("template-findcandidatesreq");
                responseTemplate = this.properties.getProperty("template-findcandidatesresp");
            }
            try {
                Element msgControlId = DocumentHelper.createElement((String)"messageControlId");
                msgControlId.setText(ServiceLocator.getInstance().getHL7Service().generateMessageControlId(domain));
                mpi.getRootElement().add(msgControlId);
                Element responseMessageControlId = DocumentHelper.createElement((String)"responseMessageControlId");
                responseMessageControlId.setText(ServiceLocator.getInstance().getHL7Service().generateMessageControlId(domain));
                mpi.getRootElement().add(responseMessageControlId);
                HL7AuditDAO dao = ServiceLocator.getInstance().getDAOFactory().createHL7AuditLogDAO();
                Adapter requestAdapter = new XSLTAdapterFactory(requestTemplate).createAdapter();
                requestAdapter.setInput(mpi);
                requestAdapter.adapt();
                String request = (String)requestAdapter.getResult();
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                XMLWriter writer = new XMLWriter((OutputStream)os, OutputFormat.createPrettyPrint());
                writer.write(patient.getXmlDocument());
                dao.storeMessage(domain, request, os.toString());
                Adapter responseAdapter = new XSLTAdapterFactory(responseTemplate).createAdapter();
                responseAdapter.setInput(mpi);
                responseAdapter.adapt();
                final String response = ((String)responseAdapter.getResult()).replace('\n', '\r');
                ServiceLocator.getInstance().getJmsTemplate(this.properties.getProperty("jmsTemplateId")).send(new MessageCreator(){

                    public Message createMessage(Session session) throws JMSException {
                        BytesMessage message = session.createBytesMessage();
                        message.writeBytes(response.getBytes());
                        return message;
                    }
                });
            }
            catch (Exception e) {
                String errorMsg = "An error occurred while transforming and sending stub find candidates response.";
                IMSException.getIMSException(new MPIException(errorMsg, e), (CharSequence)errorMsg, "MpiStubClient.findCandidates", ErrorCode.CMPI_003, new String[]{errorMsg});
            }
        } else {
            String errorMsg = "No local identifier available to create dummy ICN.";
            IMSException.getIMSException(new MPIException(errorMsg), (CharSequence)errorMsg, "MpiStubClient.findCandidates", ErrorCode.CMPI_003, new String[]{errorMsg});
        }
    }

    private boolean isLinkPatient(PatientIdentifier pid) {
        return pid.getDomain().endsWith("200HD");
    }
}

