/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.mpi.hl7.mllp;

import gov.fhie.common.util.DateTimeUtility;
import gov.fhie.transformer.hl7adapters.hl7messagebuilder.HL7SegmentParser;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.common.adapter.Adapter;
import gov.va.med.hds.hdr.common.adapter.xslt.XSLTAdapterFactory;
import gov.va.med.hds.hdr.common.net.MllpNetworkClient;
import gov.va.med.hds.hdr.hl7.HL7MessageInfo;
import gov.va.med.hds.hdr.hl7.HL7MessageInfoImpl;
import gov.va.med.hds.hdr.service.ServiceLocator;
import gov.va.med.hds.hdr.service.dao.DataAccessException;
import gov.va.med.hds.hdr.service.dao.HL7AuditDAO;
import gov.va.med.hds.hdr.service.hl7.HL7Service;
import gov.va.med.hds.hdr.service.mpi.MPIException;
import gov.va.med.hds.hdr.service.mpi.MasterPatientIndex;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegment;
import gov.va.med.hds.hdr.transformer.hl7.model.MshSegmentFactory;
import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Properties;
import org.dom4j.Document;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.dom4j.io.OutputFormat;
import org.dom4j.io.XMLWriter;

public class MpiMllpClient
implements MasterPatientIndex {
    public static final String PROP_HOST = "host";
    public static final String PROP_PORT = "port";
    public static final String PROP_TOUT = "timeout";
    public static final String PROP_STNO = "stationNumber";
    public static final String PROP_SFAC = "sendingFacility";
    public static final String PROP_RFAC = "receivingFacility";
    public static final String PROP_ENVF = "environmentFlag";
    public static final String PROP_LATT = "recordLinkingAttribute";
    public static final String TMPL_FINDCANDIDATES = "template-findcandidates";
    public static final String TMPL_LINKPATIENT = "template-linkpatient";
    public static final long DEFAULT_NETWORK_TIMEOUT = 10000L;
    private Properties serviceProperties = null;
    private String host = null;
    private int port = -1;
    private long timeout = 10000L;
    private String stno = null;
    private String sfac = null;
    private String rfac = null;
    private String latt = null;
    private String envf = null;

    public MpiMllpClient(Properties properties) throws MPIException {
        String linkPatient;
        String findCandidates;
        this.serviceProperties = properties;
        ArrayList<String> errors = new ArrayList<String>();
        this.host = this.serviceProperties.getProperty(PROP_HOST);
        if (this.host == null || this.host.length() == 0) {
            errors.add("The required host property cannot be null or zero-length.");
        }
        try {
            this.port = Integer.parseInt(this.serviceProperties.getProperty(PROP_PORT));
        }
        catch (NumberFormatException nfe) {
            errors.add("The required 'port' property was either not provided or is not a valid integer.");
        }
        try {
            this.timeout = Long.parseLong(this.serviceProperties.getProperty(PROP_TOUT));
        }
        catch (NumberFormatException nfe) {
            this.serviceProperties.setProperty(PROP_TOUT, Long.toHexString(10000L));
        }
        this.stno = this.serviceProperties.getProperty(PROP_STNO);
        if (this.stno == null || this.stno.length() == 0) {
            errors.add("The required 'stationNumber' property cannot be null or zero-length.");
        }
        this.sfac = this.serviceProperties.getProperty(PROP_SFAC);
        if (this.sfac == null || this.sfac.length() == 0) {
            errors.add("The required 'sendingFacility' property cannot be null or zero-length.");
        }
        this.rfac = this.serviceProperties.getProperty(PROP_RFAC);
        if (this.rfac == null || this.rfac.length() == 0) {
            errors.add("The required 'receivingFacility' property cannot be null or zero-length.");
        }
        this.latt = this.serviceProperties.getProperty(PROP_LATT);
        if (this.latt == null || this.latt.length() == 0) {
            errors.add("The required 'recordLinkingAttribute' property cannot be null or zero-length.");
        }
        this.envf = this.serviceProperties.getProperty(PROP_ENVF);
        if (this.envf == null || this.envf.length() != 1 || this.envf.charAt(0) != 'P' && this.envf.charAt(0) != 'T') {
            errors.add("The required 'environmentFlag' property cannot be null and must be either the character 'P' or the character 'T'.");
        }
        if ((findCandidates = this.serviceProperties.getProperty(TMPL_FINDCANDIDATES)) == null || findCandidates.length() == 0) {
            errors.add("The required 'template-findcandidates' property cannot be null or zero-length.");
        }
        if ((linkPatient = this.serviceProperties.getProperty(TMPL_LINKPATIENT)) == null || linkPatient.length() == 0) {
            errors.add("The required 'template-linkpatient' property cannot be null or zero-length.");
        }
        if (errors.size() > 0) {
            StringBuffer msg = new StringBuffer();
            msg.append("The following error(s) occurred while instantiating the service.\n");
            for (int i = 0; i < errors.size(); ++i) {
                msg.append((String)errors.get(i)).append('\n');
            }
            throw new MPIException(msg.toString());
        }
    }

    public void correlatePatient(String domain, Patient patient) throws MPIException {
        Object icn = null;
        PatientIdentifier[] lids = patient.getIdentifiers(3);
        Document mpi = DocumentHelper.createDocument((Element)DocumentHelper.createElement((String)"mpi"));
        String msgDateTime = DateTimeUtility.getCurrentTime();
        Element dateTime = DocumentHelper.createElement((String)"messageDateTime");
        dateTime.setText(msgDateTime);
        mpi.getRootElement().add(dateTime);
        String messageControlId = null;
        try {
            HL7Service hl7Service = ServiceLocator.getInstance().getHL7Service();
            messageControlId = hl7Service.generateMessageControlId(domain);
        }
        catch (Exception e) {
            throw IMSException.getIMSException("Error creating message control Id.", e);
        }
        Element msgControlId = DocumentHelper.createElement((String)"messageControlId");
        msgControlId.setText(messageControlId);
        mpi.getRootElement().add(msgControlId);
        Element stationNumber = DocumentHelper.createElement((String)PROP_STNO);
        stationNumber.setText(this.stno);
        mpi.getRootElement().add(stationNumber);
        Element sendingFacility = DocumentHelper.createElement((String)PROP_SFAC);
        sendingFacility.setText(this.sfac);
        mpi.getRootElement().add(sendingFacility);
        Element receivingFacility = DocumentHelper.createElement((String)PROP_RFAC);
        receivingFacility.setText(this.rfac);
        mpi.getRootElement().add(receivingFacility);
        Element linkAttribute = DocumentHelper.createElement((String)PROP_LATT);
        linkAttribute.setText(this.latt);
        mpi.getRootElement().add(linkAttribute);
        Element environmentFlag = DocumentHelper.createElement((String)PROP_ENVF);
        environmentFlag.setText(this.envf);
        mpi.getRootElement().add(environmentFlag);
        Element patientElement = (Element)patient.getXmlDocument().getRootElement().clone();
        mpi.getRootElement().add(patientElement);
        String template = null;
        template = lids != null && lids.length > 0 && this.isLinkPatient(lids[0]) ? this.serviceProperties.getProperty(TMPL_LINKPATIENT) : this.serviceProperties.getProperty(TMPL_FINDCANDIDATES);
        HL7AuditDAO dao = null;
        MllpNetworkClient client = MllpNetworkClient.getInstance();
        try {
            HL7MessageInfoImpl messageInfo;
            Adapter adapter = new XSLTAdapterFactory(template).createAdapter();
            adapter.setInput(mpi);
            adapter.adapt();
            String findCandidatesRequest = (String)adapter.getResult();
            dao = ServiceLocator.getInstance().getDAOFactory().createHL7AuditLogDAO();
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            XMLWriter writer = new XMLWriter((OutputStream)os, OutputFormat.createPrettyPrint());
            writer.write(patient.getXmlDocument());
            dao.storeMessage(domain, findCandidatesRequest, os.toString());
            String response = client.doRequest(findCandidatesRequest, this.host, this.port, this.timeout);
            dao.addMessage(domain, messageControlId, response);
            if (null == response || 0 == response.length()) {
                throw new MPIException("No response from MPI service for request:\n" + findCandidatesRequest + "\n");
            }
            String[] segments = response.split(HL7MessageInfo.LINE_DELIMETER);
            String msh = segments[0];
            MshSegment mshSegment = MshSegmentFactory.createSegment(HL7SegmentParser.parseLine(msh, (HL7MessageInfo)(messageInfo = new HL7MessageInfoImpl(response))), (HL7MessageInfo)messageInfo);
            if (!"ACK".equals(mshSegment.getMessageType())) {
                throw new MPIException("Received unknown reply from MPI service.\nRequest: \n" + findCandidatesRequest + "\nResponse: \n" + response + "\n");
            }
            for (int i = 1; i < segments.length; ++i) {
                if (!segments[i].startsWith("MSA") || segments[i].startsWith("MSA^CA")) continue;
                throw new MPIException("Received NACK from MPI service.\nRequest: " + findCandidatesRequest + "Response: " + response);
            }
            String currentStatus = dao.getStatus(domain, messageControlId);
            if (!currentStatus.startsWith("C") && !currentStatus.startsWith("E")) {
                dao.setStatus(domain, messageControlId, "P");
            }
        }
        catch (MPIException mpie) {
            try {
                dao.setStatus(domain, messageControlId, "E");
            }
            catch (DataAccessException dae) {
                IMSException.getIMSException(dae);
            }
            throw mpie;
        }
        catch (Exception e) {
            try {
                dao.setStatus(domain, messageControlId, "E");
            }
            catch (DataAccessException dae) {
                IMSException.getIMSException(dae);
            }
            throw new MPIException(e);
        }
    }

    private boolean isLinkPatient(PatientIdentifier pid) {
        return pid.getDomain().endsWith("200HD");
    }
}

