/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.hl7.local;

import gov.fhie.common.properties.PropertyElement;
import gov.fhie.transformer.supportclasslibraries.loggerlibrary.IMSException;
import gov.va.med.hds.hdr.busobj.hl7.ApplicationAcknowledgmentResponse;
import gov.va.med.hds.hdr.service.ServiceException;
import gov.va.med.hds.hdr.service.hl7.DataDomainIdPrependerUIDGenerator;
import gov.va.med.hds.hdr.service.hl7.HL7Service;
import gov.va.med.hds.hdr.service.hl7.UIDGenerator;
import gov.va.med.hds.hdr.transformer.jms.QueueLocator;
import gov.va.med.hds.hdr.transformer.jms.QueueLocatorException;
import gov.va.med.hds.hdr.transformer.jms.QueueLocatorFactory;
import java.lang.reflect.Method;
import java.util.Properties;

public class LocalHL7Service
implements HL7Service {
    public static final String PROP_UIDGENERATOR_CLASS = "uidGeneratorClass";
    public static final String PROP_APPLICATION_ACK_MODE = "applicationAck_Mode";
    public static final String PROP_APPLICATION_ACK_CLASS = "applicationAck_Class";
    public static final String PROP_APPLICATION_ACK_METHOD = "applicationAck_Method";
    public static final String PROP_APPLICATION_ACK_URL = "applicationAck_URL";
    public static final String PROP_APPLICATION_ACK_DOMAIN = "applicationAck_Domain";
    public static final String PROP_APPLICATION_ACK_SENDING_FACILITY = "applicationAck_SendingFacility";
    public static final String PROP_APPLICATION_ACK_QUEUE_LOCATOR = "applicationAck_QueueLocator";
    private final Properties props;
    private final boolean ackMode;
    private Class appAckClass = null;
    private UIDGenerator uidGenerator = new DataDomainIdPrependerUIDGenerator();
    private volatile Method appAckMethod;
    int appAckMode = 0;
    private volatile QueueLocator appAckQueueLocator;

    public LocalHL7Service(Properties props) {
        String uidGeneratorClass;
        this.props = props;
        String mode = this.getProperty(PROP_APPLICATION_ACK_MODE);
        boolean bl = this.ackMode = null != mode && !mode.equals(HL7Service.APPLICATION_ACK_MODES[2]);
        if (this.ackMode) {
            String className = this.getProperty(PROP_APPLICATION_ACK_CLASS);
            try {
                this.appAckClass = Class.forName(className);
            }
            catch (Exception e) {
                IMSException.getIMSException("Error creating appAckClass '" + className + "'.");
            }
        }
        if ((uidGeneratorClass = this.props.getProperty(PROP_UIDGENERATOR_CLASS)) != null && uidGeneratorClass.length() > 0) {
            try {
                Class<?> clazz = Class.forName(uidGeneratorClass);
                this.uidGenerator = (UIDGenerator)clazz.newInstance();
            }
            catch (Exception e) {
                IMSException.getIMSException("Error creating UID Generator class named '" + uidGeneratorClass + "'.");
            }
        }
    }

    public String generateMessageControlId(String dataDomain) throws ServiceException {
        return this.uidGenerator.generate(dataDomain);
    }

    public String getDataDomainId(String messageControlId) throws ServiceException {
        return this.uidGenerator.decode(messageControlId).toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Method getApplicationAcknowledgeMethod() {
        if (null == this.appAckMethod && this.ackMode) {
            LocalHL7Service localHL7Service = this;
            synchronized (localHL7Service) {
                if (null == this.appAckMethod) {
                    String methodName = this.getProperty(PROP_APPLICATION_ACK_METHOD);
                    try {
                        this.appAckMethod = this.appAckClass.getMethod(methodName, String.class);
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
        return this.appAckMethod;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getApplicationAcknowledgeMode() {
        if (0 == this.appAckMode) {
            LocalHL7Service localHL7Service = this;
            synchronized (localHL7Service) {
                if (0 == this.appAckMode) {
                    String mode = this.getProperty(PROP_APPLICATION_ACK_MODE);
                    for (int i = 0; i < APPLICATION_ACK_MODES.length; ++i) {
                        if (!APPLICATION_ACK_MODES[i].equals(mode)) continue;
                        this.appAckMode = i + 1;
                        break;
                    }
                }
            }
        }
        return this.appAckMode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ApplicationAcknowledgmentResponse getApplicationAcknowledgeResponseObject() {
        ApplicationAcknowledgmentResponse appAckResp = null;
        if (this.ackMode) {
            LocalHL7Service localHL7Service = this;
            synchronized (localHL7Service) {
                try {
                    appAckResp = (ApplicationAcknowledgmentResponse)this.appAckClass.newInstance();
                }
                catch (Exception e) {
                    System.out.println("No application acknowledgements will be tendered from this server due to exception when instantiating appAckClass: " + e);
                }
            }
        }
        return appAckResp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public QueueLocator getApplicationAcknowledgeJMSQueueLocator() throws QueueLocatorException {
        if (null == this.appAckQueueLocator && this.ackMode) {
            LocalHL7Service localHL7Service = this;
            synchronized (localHL7Service) {
                PropertyElement[] queueLocatorPE;
                if (null == this.appAckQueueLocator && null != (queueLocatorPE = (PropertyElement[])this.props.get(PROP_APPLICATION_ACK_QUEUE_LOCATOR))) {
                    this.appAckQueueLocator = QueueLocatorFactory.createInstance(queueLocatorPE[0]);
                }
            }
        }
        return this.appAckQueueLocator;
    }

    public String getApplicationAcknowledgeURL() {
        return this.props.getProperty(PROP_APPLICATION_ACK_URL);
    }

    public String getApplicationAcknowledgeDomain() {
        return this.props.getProperty(PROP_APPLICATION_ACK_DOMAIN);
    }

    public String getApplicationAcknowledgeSendingFacility() {
        return this.props.getProperty(PROP_APPLICATION_ACK_SENDING_FACILITY);
    }

    public String getProperty(String propertyName) {
        return this.props.getProperty(propertyName);
    }
}

