/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.dao.oracle;

import gov.fhie.common.properties.PropertyMgr;
import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.busobj.patient.Patient;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.busobj.patient.PatientRecord;
import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import gov.va.med.hds.hdr.common.util.Checksum;
import gov.va.med.hds.hdr.service.dao.DataAccessException;
import gov.va.med.hds.hdr.service.dao.PatientDAO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.text.MessageFormat;
import java.util.List;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class OraclePatientDOA
implements PatientDAO {
    private static final String SQL_GETCORELATEDID = "select correlated_id from domain_id where domain=? and domain_id=? and state='ACTIVE' and clinicals='Y'";
    private static final String SQL_GETLOCALIDS = "select domain, domain_id from domain_id where correlated_id=? and domain<>? and state='ACTIVE' and clinicals='Y'";
    private static final String SQL_GETIDS = "select domain, domain_id from domain_id where correlated_id = ? and state='ACTIVE' and clinicals='Y'";
    private static final String SQL_GETLOCALIDSFORDOMAIN = "select domain_id from domain_id where correlated_id=? and domain=? and state='ACTIVE' and clinicals='Y'";
    private static final String SQL_GETMPIINFO = "select correlated_id, first_nm, middle_nm, last_nm, suffix, ssn, dob from mpi where correlated_id=?";
    private static final String SQL_FINDLOCALCORRELATION = "select correlated_id, domain_id, domain from domain_id where domain='fhie.gov/va0' and correlated_id in (select correlated_id from domain_id where domain_id=? and domain=?)";
    private static final String SQL_FINDTHISAUDIT = "select date_time from id_modification where domain_id=? and domain=? and icn=? and operation=? and fr_icn=? and fr_domain_id=? and fr_domain=?";
    private static final String SQL_UPDATECORRELATEDID = "update domain_id set correlated_id = ? where domain = ? and domain_id = ?";
    private static final String SQL_MOVEIDENTIFIERS = "update domain_id set correlated_id = ? where correlated_id = ?";
    private static final String SQL_UPDATECORRELATION = "update domain_id set ";
    private static final String SQL_WHERECORRELATED = "where correlated_id=?";
    private static final String SQL_WHEREDOMAINID = " domain_id=?";
    private static final String SQL_WHERESTATIONID = " domain=?";
    private static final String SQL_NEWMPI = "insert into mpi values (?, ?, ?, ?, ?, ?, ?, 'FALSE')";
    private static final String SQL_NEWIDMOD = "insert into id_modification (date_time,source_corr_id,destination_corr_id,source_first_nm,source_last_nm,source_ssn,source_dob,domain_id,domain,operation) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_AUDITADT = "insert into id_modification (date_time,source_corr_id,destination_corr_id,source_first_nm,source_last_nm,source_ssn,source_dob,domain_id,domain,operation,icn,fr_icn,fr_domain_id,fr_domain) values (?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?, ?)";
    private static final String SQL_NEWCORRELATION = "insert into domain_id (correlated_id, domain, domain_id, state, clinicals) values (?, ?, ?, 'ACTIVE', 'Y')";
    private static final String SQL_UPDATEPATIENTDEMOGRAPH = "update mpi set first_nm=?, middle_nm=?, last_nm=?, suffix=?, ssn=?, dob=? where correlated_id=?";
    private static final String SQL_MPIREMOVE = "delete from mpi where correlated_id=?";
    private static final String SQL_DMNREMOVE = "delete from domain_id where correlated_id=?";
    private static final String SQL_CORRREMOVE = "delete from domain_id where correlated_id=? and domain=?";
    private static final String SQL_INSERTCORRELATED = "insert into mpi (correlated_id) values (?)";
    private static final String SQL_INSERTMPI = "insert into mpi (correlated_id, first_nm, middle_nm, last_nm, suffix, ssn, dob) values (?,?,?,?,?,?,?)";
    private static final String SQL_INSERTDOMAINID = "insert into domain_id (correlated_id, domain, domain_id, state, clinicals) values (?,?,?,'ACTIVE','Y')";
    private static final String SQL_UPDATEIDENTIFIERSTATUS = "update domain_id set status=? where correlated_id=? and domain=? and domain_id=?";
    private static final String ICN_DATA_DOMAIN = "FHIE.GOV/VA0";

    public PatientIdentifier getCorreledId(PatientIdentifier pid, String dataDomain) throws DataAccessException {
        PatientIdentifier correlatedId = null;
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            int cid = jdbcTemplate.queryForInt(SQL_GETCORELATEDID, new Object[]{pid.getDomain().toUpperCase(), pid.getId()});
            correlatedId = new PatientIdentifier(dataDomain, Integer.toString(cid));
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients correlated ID from the data store.", e);
        }
        return correlatedId;
    }

    public PatientIdentifier findCorrelatedIdForPatient(Patient patient, String dataDomain) throws DataAccessException {
        PatientIdentifier cid = patient.getCorrelatedIdForDomain(dataDomain);
        if (cid == null) {
            PatientIdentifier[] nids;
            long correlatedId = -1L;
            for (PatientIdentifier nid : nids = patient.getIdentifiers(2)) {
                correlatedId = this.findCorrelatedIdByPatientId(nid, dataDomain);
                if (correlatedId == -1L) continue;
                cid = new PatientIdentifier(dataDomain, Long.toString(correlatedId));
                patient.addIdentifier(cid, 1);
                break;
            }
            if (cid == null) {
                PatientIdentifier[] lids;
                for (PatientIdentifier lid : lids = patient.getIdentifiers(0)) {
                    correlatedId = this.findCorrelatedIdByPatientId(lid, dataDomain);
                    if (correlatedId == -1L) continue;
                    cid = new PatientIdentifier(dataDomain, Long.toString(correlatedId));
                    patient.addIdentifier(cid, 1);
                    break;
                }
            }
        }
        return cid;
    }

    public PatientIdentifier[] getLocalIds(PatientIdentifier pid, String dataDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            ParameterizedRowMapper<PatientIdentifier> rowMapper = new ParameterizedRowMapper<PatientIdentifier>(){

                public PatientIdentifier mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return new PatientIdentifier(rs.getString("DOMAIN"), rs.getString("DOMAIN_ID"));
                }
            };
            List pids = jdbcTemplate.query(SQL_GETLOCALIDS, (ParameterizedRowMapper)rowMapper, new Object[]{pid.getId(), pid.getDomain()});
            return pids.toArray(new PatientIdentifier[pids.size()]);
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients local IDs from the data store.", e);
        }
    }

    public PatientIdentifier[] findIdsByCorrelatedId(Long correlatedId, String dataDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            ParameterizedRowMapper<PatientIdentifier> rowMapper = new ParameterizedRowMapper<PatientIdentifier>(){

                public PatientIdentifier mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return new PatientIdentifier(rs.getString("DOMAIN"), rs.getString("DOMAIN_ID"));
                }
            };
            List pids = jdbcTemplate.query(SQL_GETIDS, (ParameterizedRowMapper)rowMapper, new Object[]{correlatedId});
            return pids.toArray(new PatientIdentifier[pids.size()]);
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients local IDs from the data store.", e);
        }
    }

    public void moveIdentifiers(Patient patient, Long fromCorrelatedId, Long toCorrelatedId, String dataDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            PatientIdentifier[] movingPids = this.findIdsByCorrelatedId(fromCorrelatedId, dataDomain);
            String isoTime = DateTimeUtility.getCurrentTime();
            for (PatientIdentifier pid : movingPids) {
                jdbcTemplate.update(SQL_NEWIDMOD, new Object[]{isoTime, fromCorrelatedId, toCorrelatedId, null, null, null, null, pid.getId(), pid.getDomain(), "LINK_AUDIT"});
            }
            jdbcTemplate.update(SQL_MOVEIDENTIFIERS, new Object[]{toCorrelatedId, fromCorrelatedId});
            patient.removeIdentifier(new PatientIdentifier(dataDomain, fromCorrelatedId.toString()), 1);
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while moving the identifiers.", e);
        }
    }

    public void deleteIdentifiers(Long correlatedId, String dataDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            jdbcTemplate.update(SQL_DMNREMOVE, new Object[]{correlatedId});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while deleting the identifiers.", e);
        }
    }

    public PatientRecord[] getExistingLocalId(PatientIdentifier pid, String dataDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            ParameterizedRowMapper<PatientRecord> rowMapper = new ParameterizedRowMapper<PatientRecord>(){

                public PatientRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return new PatientRecord(rs.getInt("CORRELATED_ID"), rs.getString("DOMAIN_ID"), rs.getString("DOMAIN"), null, null, null, null, null, null, rs.getString("DOMAIN_ID"));
                }
            };
            List patientRecords = jdbcTemplate.query(SQL_FINDLOCALCORRELATION, (ParameterizedRowMapper)rowMapper, new Object[]{pid.getId(), pid.getDomain()});
            return patientRecords.toArray(new PatientRecord[patientRecords.size()]);
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients local IDs from the data store.", e);
        }
    }

    public PatientIdentifier[] getLocalIdsForDomain(PatientIdentifier pid, String dataDomain, final String domain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            ParameterizedRowMapper<PatientIdentifier> rowMapper = new ParameterizedRowMapper<PatientIdentifier>(){

                public PatientIdentifier mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return new PatientIdentifier(domain, rs.getString("DOMAIN_ID"));
                }
            };
            List pids = jdbcTemplate.query(SQL_GETLOCALIDSFORDOMAIN, (ParameterizedRowMapper)rowMapper, new Object[]{Integer.parseInt(pid.getId().toUpperCase()), domain.toUpperCase()});
            return pids.toArray(new PatientIdentifier[pids.size()]);
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients local identifiers with the specified domain from the data store.", e);
        }
    }

    public long findCorrelatedIdByPatientId(PatientIdentifier pid, String dataDomain) throws DataAccessException {
        long retVal = -1L;
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            ParameterizedRowMapper<Long> rowMapper = new ParameterizedRowMapper<Long>(){

                public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getLong("CORRELATED_ID");
                }
            };
            List correlatedIds = jdbcTemplate.query("SELECT CORRELATED_ID FROM DOMAIN_ID WHERE DOMAIN=? and DOMAIN_ID=?", (ParameterizedRowMapper)rowMapper, new Object[]{pid.getDomain(), pid.getId()});
            if (correlatedIds != null && correlatedIds.size() != 0) {
                if (correlatedIds.size() != 1) {
                    throw new DataAccessException(String.format("Warning: Multiple correlated IDs found for single domain/domain_id cobination. Domain: %s, Domain ID: %s.", pid.getDomain(), pid.getId()));
                }
                retVal = (Long)correlatedIds.get(0);
            }
        }
        catch (DataAccessException dae) {
            throw dae;
        }
        catch (Exception e) {
            throw new DataAccessException("A problem was encountered while finding the correlated ID by patient Id.", e);
        }
        if (retVal == -1L && pid.getDomain().equals(dataDomain)) {
            retVal = this.findCorrelatedIdByICNNoChecksum(pid, dataDomain, retVal);
        }
        return retVal;
    }

    public long findCorrelatedIdByICNNoChecksum(final PatientIdentifier pid, final String dataDomain, long corrId) throws DataAccessException {
        long retVal = -1L;
        String[] ICN = pid.getId().split("V");
        if (ICN.length != 2) {
            return retVal;
        }
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            ParameterizedRowMapper<Long> rowMapper = new ParameterizedRowMapper<Long>(){

                public Long mapRow(ResultSet rs, int rowNum) throws SQLException {
                    PatientRecord patRec = new PatientRecord(2, pid.getId(), pid.getDomain(), "", "", "", "", "", "", pid.getId());
                    Long corrID = rs.getLong("CORRELATED_ID");
                    patRec.setCorrId(corrID.toString());
                    try {
                        OraclePatientDOA.this.addICNPatID(patRec, dataDomain);
                    }
                    catch (DataAccessException e) {
                        throw new SQLException(e.getMessage());
                    }
                    return corrID;
                }
            };
            List correlatedIds = jdbcTemplate.query("SELECT CORRELATED_ID FROM DOMAIN_ID WHERE DOMAIN=? and DOMAIN_ID LIKE ?", (ParameterizedRowMapper)rowMapper, new Object[]{pid.getDomain(), ICN[0].concat("V%")});
            if (correlatedIds != null && correlatedIds.size() != 0) {
                if (correlatedIds.size() != 1) {
                    throw new DataAccessException(String.format("Warning: Multiple correlated IDs found for single domain/domain_id cobination. Domain: %s, Domain ID: %s.", pid.getDomain(), pid.getId()));
                }
                retVal = (Long)correlatedIds.get(0);
            }
        }
        catch (DataAccessException dae) {
            throw dae;
        }
        catch (Exception e) {
            throw new DataAccessException("A problem was encountered while finding the correlated ID by patient Id.", e);
        }
        return retVal;
    }

    public PatientIdentifier findNationalIdByPatientId(PatientIdentifier pid, String dataDomain) throws DataAccessException {
        throw new UnsupportedOperationException();
    }

    public PatientIdentifier getPossibleCorrelatedId(PatientIdentifier pid, final String dataDomain) throws DataAccessException {
        PatientIdentifier correlatedId = null;
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            ParameterizedRowMapper<PatientIdentifier> rowMapper = new ParameterizedRowMapper<PatientIdentifier>(){

                public PatientIdentifier mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return new PatientIdentifier(dataDomain, Integer.toString(rs.getInt("CORRELATED_ID")));
                }
            };
            List cids = jdbcTemplate.query(SQL_GETCORELATEDID, (ParameterizedRowMapper)rowMapper, new Object[]{pid.getDomain().toUpperCase(), pid.getId()});
            if (cids != null && cids.size() != 0) {
                if (cids.size() != 1) {
                    throw new DataAccessException(String.format("Found multiple correlated IDs for patient where domain is %s and domainID is %.", pid.getDomain(), pid.getId()));
                }
                correlatedId = (PatientIdentifier)cids.get(0);
            }
        }
        catch (DataAccessException dae) {
            throw dae;
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients correlated ID from the data store.", e);
        }
        return correlatedId;
    }

    public PatientRecord[] getMPIInfo(String correlatedId, String dataDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            ParameterizedRowMapper<PatientRecord> rowMapper = new ParameterizedRowMapper<PatientRecord>(){

                public PatientRecord mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return new PatientRecord(0, null, null, rs.getString(4), rs.getString(2), rs.getString(3), rs.getString(5), rs.getString(6), rs.getString(7), null);
                }
            };
            List pids = jdbcTemplate.query(SQL_GETMPIINFO, (ParameterizedRowMapper)rowMapper, new Object[]{correlatedId.toUpperCase()});
            return pids.toArray(new PatientRecord[pids.size()]);
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients local IDs from the data store.", e);
        }
    }

    public PatientIdentifier createCorrelatedId(String dataDomain) throws DataAccessException {
        long correlatedId = this.getNextCorrelatedId(dataDomain);
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            jdbcTemplate.update(SQL_INSERTCORRELATED, new Object[]{correlatedId});
        }
        catch (SQLException sqle) {
            throw new DataAccessException("An error occurred while creating a correlated ID for the patient.", sqle);
        }
        return new PatientIdentifier(dataDomain, Long.toString(correlatedId));
    }

    public void storePatientDemographics(Patient patient, String dataDomain) throws DataAccessException {
        PatientIdentifier cid = patient.getCorrelatedIdForDomain(dataDomain);
        if (cid == null) {
            cid = this.findCorrelatedIdForPatient(patient, dataDomain);
        }
        if (cid == null) {
            this.insertPatientDemographics(patient, dataDomain);
        } else {
            this.updatePatientDemographics(patient, dataDomain);
        }
    }

    private void insertPatientDemographics(Patient patient, String dataDomain) throws DataAccessException {
        long correlatedId = this.getNextCorrelatedId(dataDomain);
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            jdbcTemplate.update(SQL_INSERTMPI, new Object[]{correlatedId, patient.getFirstName(), patient.getMiddleName(), patient.getLastName(), patient.getSuffix(), patient.getSsn(), patient.getDob()});
        }
        catch (Exception e) {
            throw new DataAccessException("An error was encountered while storing the new patient to the MPI.", e);
        }
        patient.addIdentifier(new PatientIdentifier(dataDomain, Long.toString(correlatedId)), 1);
    }

    private void updatePatientDemographics(Patient patient, String dataDomain) throws DataAccessException {
        try {
            PatientIdentifier cid = patient.getCorrelatedIdForDomain(dataDomain);
            if (cid == null) {
                throw new Exception("Patient must have a correlated ID to be updateable.");
            }
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            jdbcTemplate.update(SQL_UPDATEPATIENTDEMOGRAPH, new Object[]{patient.getFirstName(), patient.getMiddleName(), patient.getLastName(), patient.getSuffix(), patient.getSsn(), patient.getDob(), Long.parseLong(cid.getId())});
        }
        catch (Exception e) {
            throw new DataAccessException("An error was encountered while updating the existing patient to the MPI.", e);
        }
    }

    public long getNextCorrelatedId(String dataDomain) throws DataAccessException {
        long retVal = -1L;
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            retVal = jdbcTemplate.queryForInt("SELECT CORRELATED_ID_SEQ.NEXTVAL FROM DUAL", new Object[0]);
        }
        catch (Exception e) {
            throw new DataAccessException("An error was encountered while getting the next value from the correlated ID sequence.", e);
        }
        return retVal;
    }

    public void storeDomainIdentifier(PatientIdentifier correlatedId, PatientIdentifier pid, String dataDomain) throws DataAccessException {
        if (!this.goodDomain(pid.getId()) && !pid.getDomain().equals(dataDomain)) {
            return;
        }
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            jdbcTemplate.update(SQL_INSERTDOMAINID, new Object[]{Integer.parseInt(correlatedId.getId()), pid.getDomain(), pid.getId()});
        }
        catch (Exception e) {
            throw new DataAccessException("A problem was encountered while storing the identifier for the patient.", e);
        }
    }

    private boolean goodDomain(String ICNwChecksum) {
        String ICN = new String();
        if (ICNwChecksum.indexOf(86) == -1) {
            return true;
        }
        ICN = ICNwChecksum.split("V")[0];
        String goodICN = Checksum.addChecksumToIcn(ICN);
        return goodICN.equals(ICNwChecksum);
    }

    public void updateIdentifierStatus(long correlatedId, PatientIdentifier patientId, String dataDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            jdbcTemplate.update(SQL_UPDATEIDENTIFIERSTATUS, new Object[]{patientId.getStatus(), correlatedId, patientId.getDomain(), patientId.getId()});
        }
        catch (Exception e) {
            throw new DataAccessException("A problem was encountered while updating the patient identifier.", e);
        }
    }

    public void storeDomainIdentifier(Patient patient, PatientIdentifier pid, String dataDomain) throws DataAccessException {
        PatientIdentifier cid = patient.getCorrelatedIdForDomain(dataDomain);
        if (cid == null) {
            throw new DataAccessException("Patient must have a correlated identifier prior to storing a local identifier for them.");
        }
        this.storeDomainIdentifier(cid, pid, dataDomain);
    }

    public void addLocalPatID(PatientRecord patientInfo, String dataDomain) throws DataAccessException {
        PropertyMgr pmgr = PropertyMgr.getInstance(dataDomain);
        String namingEntityPrefix = pmgr.getProperty("naming_entity_prefix").getValue();
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            jdbcTemplate.update(SQL_NEWCORRELATION, new Object[]{patientInfo.getCorrId() != null ? (long)Integer.parseInt(patientInfo.getCorrId().toUpperCase()) : this.getNextCorrelatedId(dataDomain), namingEntityPrefix == null ? patientInfo.getStationId().toUpperCase() : namingEntityPrefix + patientInfo.getStationId().toUpperCase(), patientInfo.getDomain().toUpperCase()});
        }
        catch (SQLException sqle) {
            if (!sqle.getMessage().toUpperCase().startsWith("ORA-00001")) {
                throw new DataAccessException("An error occurred while getting the patients correlated ID from the data store.", sqle);
            }
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients correlated ID from the data store.", e);
        }
    }

    public String addChildPatID(PatientRecord patientInfo, String dataDomain) throws DataAccessException {
        String corrId = null;
        try {
            corrId = patientInfo.getCorrId() == null ? this.addToMPI(patientInfo, dataDomain) : patientInfo.getCorrId().toUpperCase();
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            jdbcTemplate.update(SQL_NEWCORRELATION, new Object[]{Integer.parseInt(corrId), patientInfo.getStationId().toUpperCase(), patientInfo.getDomain().toUpperCase()});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients correlated ID from the data store.", e);
        }
        return corrId;
    }

    public String addICNPatID(PatientRecord patientInfo, String dataDomain) throws DataAccessException {
        String correlatedId = null;
        try {
            correlatedId = patientInfo.getCorrId() != null ? patientInfo.getCorrId().toUpperCase() : Long.toString(this.getNextCorrelatedId(dataDomain));
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(dataDomain));
            jdbcTemplate.update(SQL_NEWCORRELATION, new Object[]{Integer.parseInt(correlatedId), ICN_DATA_DOMAIN, patientInfo.getICN().toUpperCase()});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred while getting the patients correlated ID from the data store.", e);
        }
        return correlatedId;
    }

    public String addToMPI(PatientRecord patientInfo, String originatingDomain) throws DataAccessException {
        long newCorrelatedId = -1L;
        try {
            newCorrelatedId = this.getNextCorrelatedId(originatingDomain);
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(originatingDomain));
            jdbcTemplate.update(SQL_NEWMPI, new Object[]{newCorrelatedId, patientInfo.getFirstNameU(), patientInfo.getMiddleNameU(), patientInfo.getLastNameU(), patientInfo.getSuffixNameU(), patientInfo.getSsn(), patientInfo.getDob()});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred trying to update the MPI table.", e);
        }
        return new Long(newCorrelatedId).toString();
    }

    public boolean addToIdModification(PatientRecord patientInfo, String destinationCorrId, String originatingDomain, String patientOperation) throws DataAccessException {
        try {
            int corrId = patientInfo.getCorrId() == null ? 0 : Integer.parseInt(patientInfo.getCorrId());
            int destCorrId = destinationCorrId == null ? 0 : Integer.parseInt(destinationCorrId);
            String isoTime = DateTimeUtility.getCurrentTime();
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(originatingDomain));
            jdbcTemplate.update(SQL_NEWIDMOD, new Object[]{isoTime, corrId, destCorrId, patientInfo.getFirstNameU(), patientInfo.getLastNameU(), patientInfo.getSsn(), patientInfo.getDob(), patientInfo.getDomain(), patientInfo.getStationId(), patientOperation});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred trying to update the MPI table.", e);
        }
        return true;
    }

    public boolean addToIdModification(PatientRecord patientFromInfo, PatientRecord patientToInfo, String originatingDomain, String patientOperation) throws DataAccessException {
        try {
            if (this.getExistingAuditEntry(patientFromInfo, patientToInfo, originatingDomain, patientOperation)) {
                return true;
            }
            String isoTime = DateTimeUtility.getCurrentTime();
            int fromCorrId = patientFromInfo.getCorrId() == null ? 0 : Integer.parseInt(patientFromInfo.getCorrId());
            int toCorrId = patientToInfo.getCorrId() == null ? 0 : Integer.parseInt(patientToInfo.getCorrId());
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(originatingDomain));
            jdbcTemplate.update(SQL_AUDITADT, new Object[]{isoTime, fromCorrId, toCorrId, patientToInfo.getFirstNameU(), patientToInfo.getLastNameU(), patientToInfo.getSsn(), patientToInfo.getDob(), patientToInfo.getDomain(), patientToInfo.getStationId(), patientOperation, patientToInfo.getICN(), patientFromInfo.getICN(), patientFromInfo.getDomain(), patientFromInfo.getStationId()});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred trying to update the MPI table.", e);
        }
        return true;
    }

    public boolean getExistingAuditEntry(PatientRecord patientFromInfo, PatientRecord patientToInfo, String originatingDomain, String patientOperation) throws DataAccessException {
        boolean status = false;
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(originatingDomain));
            ParameterizedRowMapper<String> rowMapper = new ParameterizedRowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString("date_time");
                }
            };
            List stamps = jdbcTemplate.query(SQL_FINDTHISAUDIT, (ParameterizedRowMapper)rowMapper, new Object[]{patientToInfo.getDomain(), patientToInfo.getStationId(), patientToInfo.getICN(), patientOperation, patientFromInfo.getICN(), patientFromInfo.getDomain(), patientFromInfo.getStationId()});
            status = stamps != null & stamps.size() > 0;
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred trying to update the MPI table.", e);
        }
        return status;
    }

    public void moveLocalIdentifier(PatientIdentifier patientIdentifier, long toCorrId, String originatingDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(originatingDomain));
            jdbcTemplate.update(SQL_UPDATECORRELATEDID, new Object[]{toCorrId, patientIdentifier.getDomain(), patientIdentifier.getId()});
        }
        catch (Exception ex) {
            throw new DataAccessException("An error occurred while trying to move the local identifier to a different correlated ID.", ex);
        }
    }

    public boolean mvLocalPatID(PatientRecord patientInfo, String originatingDomain) throws DataAccessException {
        PropertyMgr pmgr = PropertyMgr.getInstance(originatingDomain);
        String namingEntityPrefix = pmgr.getProperty("naming_entity_prefix").getValue();
        try {
            String updateLocalPatId = MessageFormat.format("{0} correlated_id={1} where {2} and {3}", SQL_UPDATECORRELATION, patientInfo.getCorrId(), SQL_WHEREDOMAINID, SQL_WHERESTATIONID);
            String domain = null;
            domain = namingEntityPrefix == null || patientInfo.getStationId().startsWith(namingEntityPrefix) ? patientInfo.getStationId() : namingEntityPrefix + patientInfo.getStationId().toUpperCase();
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(originatingDomain));
            jdbcTemplate.update(updateLocalPatId, new Object[]{patientInfo.getDomain(), domain});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred trying to update the MPI table.", e);
        }
        return true;
    }

    public void linkFromTo(String fromPatientInfo, String toPatientInfo, String currDomain) throws DataAccessException {
        try {
            String linkFromTo = MessageFormat.format("{0} correlated_id={1} {2}", SQL_UPDATECORRELATION, toPatientInfo, SQL_WHERECORRELATED);
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(currDomain));
            jdbcTemplate.update(linkFromTo, new Object[]{Integer.parseInt(fromPatientInfo.toUpperCase())});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred trying to update the MPI Domain table.", e);
        }
    }

    public void removeFromMPI(String fromPatientInfo, String currDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(currDomain));
            jdbcTemplate.update(SQL_MPIREMOVE, new Object[]{Integer.parseInt(fromPatientInfo.toUpperCase())});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred trying to update the MPI table.", e);
        }
    }

    public void removeFromCorr(String fromPatientInfo, String currDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(currDomain));
            jdbcTemplate.update(SQL_DMNREMOVE, new Object[]{Integer.parseInt(fromPatientInfo.toUpperCase())});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred trying to update the MPI table.", e);
        }
    }

    public void removeFromCorrelate(String corrId, String stationId, String currDomain) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(currDomain));
            jdbcTemplate.update(SQL_CORRREMOVE, new Object[]{Integer.parseInt(corrId.toUpperCase()), stationId});
        }
        catch (Exception e) {
            throw new DataAccessException("An error occurred trying to update the MPI table.", e);
        }
    }
}

