/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.dao.oracle;

import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import gov.va.med.hds.hdr.common.util.HL7MessageMetaData;
import gov.va.med.hds.hdr.service.dao.DataAccessException;
import gov.va.med.hds.hdr.service.dao.HL7AuditDAO;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import org.springframework.jdbc.core.simple.ParameterizedRowMapper;
import org.springframework.jdbc.core.simple.SimpleJdbcTemplate;

public class OracleHL7AuditDAO
implements HL7AuditDAO {
    private static final String queryOriginalMessage = "select message from ims_hl7_message_log where message_control_id = ? order by ims_hl7_message_log_id asc";
    private static final String insertHL7MessageLog = "insert into ims_hl7_message_log (ims_hl7_message_log_id, message_control_id, message, additional_info, message_ty, message_date_time) values (IMS_HL7_MESSAGE_LOG_SEQ.NEXTVAL, ?, ?, ?, ?, ?)";
    private static final String queryAdditionalInfo = "select additional_info from ims_hl7_message_log where message_control_id=? order by ims_hl7_message_log_id asc";
    private static final String insertStatus = "insert into ims_hl7_message_status (ims_hl7_message_status_id, message_control_id, status) values (IMS_HL7_MESSAGE_STATUS_SEQ.NEXTVAL,?,?)";
    private static final String updateStatus = "Update ims_hl7_message_status set status=? where message_control_id=?";
    private static final String queryStatus = "select status from ims_hl7_message_status where message_control_id=?";
    private static final String deleteStatus = "delete from ims_hl7_message_status where message_control_id=?";
    private static final String deleteAuditMessage = "delete from ims_hl7_audit where message_control_id=?";

    public String getOriginalMessageData(String domain, String messageControlId) throws DataAccessException {
        String data = null;
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(domain));
            ParameterizedRowMapper<String> rowMapper = new ParameterizedRowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString("ADDITIONAL_INFO");
                }
            };
            List additionalInfos = jdbcTemplate.query(queryAdditionalInfo, (ParameterizedRowMapper)rowMapper, new Object[]{messageControlId});
            if (additionalInfos != null && additionalInfos.size() > 0) {
                data = (String)additionalInfos.get(0);
            }
        }
        catch (Exception e) {
            throw new DataAccessException("Error while getting original message data.", e);
        }
        return data;
    }

    public String getOriginalMessage(String domain, String messageControlId) throws DataAccessException {
        String message = null;
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(domain));
            ParameterizedRowMapper<String> rowMapper = new ParameterizedRowMapper<String>(){

                public String mapRow(ResultSet rs, int rowNum) throws SQLException {
                    return rs.getString("MESSAGE");
                }
            };
            List messages = jdbcTemplate.query(queryOriginalMessage, (ParameterizedRowMapper)rowMapper, new Object[]{messageControlId});
            if (message != null && messages.size() > 0) {
                message = (String)messages.get(0);
            }
        }
        catch (Exception e) {
            throw new DataAccessException("Error while getting original message.", e);
        }
        return message;
    }

    public void storeMessage(String domain, String message) throws DataAccessException {
        this.storeMessage(domain, message, null);
    }

    public void storeMessage(String domain, String message, String data) throws DataAccessException {
        HL7MessageMetaData metaData = new HL7MessageMetaData(message, "");
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(domain));
            jdbcTemplate.update(insertHL7MessageLog, new Object[]{metaData.getMessageControlId(), message, data, metaData.getMessageType(), metaData.getMessageDateTime()});
            jdbcTemplate.update(insertStatus, new Object[]{metaData.getMessageControlId(), "INITIAL"});
        }
        catch (Exception e) {
            throw new DataAccessException("Error storing message. Rolling back trasaction.", e);
        }
    }

    public void setStatus(String domain, String messageControlId, String newStatus) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(domain));
            jdbcTemplate.update(updateStatus, new Object[]{newStatus, messageControlId});
        }
        catch (Exception e) {
            throw new DataAccessException(String.format("Error udating status for message control id '%s'.", messageControlId), e);
        }
    }

    public String getStatus(String domain, String messageControlId) throws DataAccessException {
        String status = null;
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(domain));
            status = (String)jdbcTemplate.queryForObject(queryStatus, String.class, new Object[]{messageControlId});
        }
        catch (Exception e) {
            throw new DataAccessException(String.format("Error getting status for message control id '%s'.", messageControlId), e);
        }
        return status;
    }

    public void removeMessages(String domain, String messageControlId) throws DataAccessException {
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(domain));
            jdbcTemplate.update(deleteStatus, new Object[]{messageControlId});
            jdbcTemplate.update(deleteAuditMessage, new Object[]{messageControlId});
        }
        catch (Exception e) {
            throw new DataAccessException(String.format("Error deleting messages from HL7 audit table  message control id '%s'.", messageControlId), e);
        }
    }

    public void addMessage(String domain, String messageControlId, String message) throws DataAccessException {
        this.addMessage(domain, messageControlId, message, null);
    }

    public void addMessage(String domain, String messageControlId, String message, String data) throws DataAccessException {
        HL7MessageMetaData metaData = new HL7MessageMetaData(message, "");
        try {
            SimpleJdbcTemplate jdbcTemplate = new SimpleJdbcTemplate(DataSourceManager.getInstance().getDataSource(domain));
            jdbcTemplate.update(insertHL7MessageLog, new Object[]{messageControlId, message, data, metaData.getMessageType(), metaData.getMessageDateTime()});
        }
        catch (Exception e) {
            throw new DataAccessException(String.format("Error adding message for message control ID '%s'. \n\n\tMessage:\n\n %s \n\n\tData:\n\n %s", messageControlId, message, data), e);
        }
    }
}

