/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.dao.hibernate;

import gov.fhie.common.util.DateTimeUtility;
import gov.va.med.hds.hdr.busobj.patient.PatientIdentifier;
import gov.va.med.hds.hdr.busobj.vhim.common.ActId;
import gov.va.med.hds.hdr.busobj.vhim.lab.LabRequest;
import gov.va.med.hds.hdr.busobj.vhim.lab.LabTest;
import gov.va.med.hds.hdr.service.dao.DataAccessException;
import gov.va.med.hds.hdr.service.dao.LaboratoryDAO;
import gov.va.med.hds.hdr.service.dao.hibernate.HibernateDAO;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.hibernate.HibernateException;
import org.hibernate.Query;
import org.hibernate.SessionFactory;
import org.hibernate.classic.Session;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HibernateLaboratoryDAO
extends HibernateDAO
implements LaboratoryDAO {
    private static final String HNQ_FINDCANDIDATE = "gov.va.med.hds.hdr.service.dao.hibernate.HibernateLaboratoryDAO.findLabTest";
    private static final String HNQ_FINDCANDIDATES = "gov.va.med.hds.hdr.service.dao.hibernate.HibernateLaboratoryDAO.findLabTests";
    private static final String HNQP_DFN = "dfn";
    private static final String HNQP_ASSIGNINGAUTHORITY = "aa";
    private static final String HNQP_START = "start";
    private static final String HNQP_END = "end";
    private static final String HNQP_COLLECTIONDATE = "collectionDate";
    private static final String HNQP_ACCESSIONID = "accessionId";

    public HibernateLaboratoryDAO(SessionFactory sessionFactory) {
        super(sessionFactory);
    }

    private LabTest findLabTest(org.hibernate.Session session, PatientIdentifier patientIdentifier, ActId accessionId, Double specimenCollectionDate) throws DataAccessException {
        Query findCandidate = session.getNamedQuery(HNQ_FINDCANDIDATE);
        findCandidate.setString(HNQP_DFN, patientIdentifier.getId());
        findCandidate.setString(HNQP_ASSIGNINGAUTHORITY, patientIdentifier.getDomain());
        findCandidate.setString(HNQP_ACCESSIONID, accessionId.getExtValue());
        findCandidate.setDouble(HNQP_COLLECTIONDATE, specimenCollectionDate.doubleValue());
        return (LabTest)findCandidate.uniqueResult();
    }

    @Override
    public Set<LabTest> findLabTests(PatientIdentifier patientIdentifier, String startDateTime, String endDateTime) throws DataAccessException {
        Double start = DateTimeUtility.isoTime2Double(startDateTime);
        Double end = DateTimeUtility.isoTime2Double(endDateTime);
        Session session = this.sessionFactory.openSession();
        Query findLabTests = session.getNamedQuery(HNQ_FINDCANDIDATES);
        findLabTests.setString(HNQP_DFN, patientIdentifier.getId());
        findLabTests.setString(HNQP_ASSIGNINGAUTHORITY, patientIdentifier.getDomain());
        findLabTests.setDouble(HNQP_START, start.doubleValue());
        findLabTests.setDouble(HNQP_END, end.doubleValue());
        HashSet<LabTest> labTests = new HashSet<LabTest>(findLabTests.list());
        session.close();
        return labTests;
    }

    @Override
    public void storeLabTests(List<LabTest> labTests) throws DataAccessException {
        ArrayList<LabTest> retList = new ArrayList<LabTest>();
        try {
            org.hibernate.Session session = this.getHibernateSession();
            this.beginTransaction();
            for (LabTest unpersisted : labTests) {
                LabTest persisted;
                Double specimenCollectionDate = unpersisted.getLabRequests().toArray(new LabRequest[0])[0].getSpecimenCollection().getCollectionDate();
                LabTest labTest = persisted = retList.contains(unpersisted) ? (LabTest)retList.get(retList.indexOf(unpersisted)) : this.findLabTest(session, unpersisted.getPatientVisit().getPatientId(), unpersisted.getAccessionId(), specimenCollectionDate);
                if (persisted != null) {
                    if (persisted.getLastUpdateDate().getTime() > unpersisted.getLastUpdateDate().getTime()) {
                        return;
                    }
                    retList.remove(persisted);
                    session.delete((Object)persisted);
                }
                session.save((Object)unpersisted);
                session.flush();
                retList.add(unpersisted);
            }
        }
        catch (HibernateException he) {
            throw new DataAccessException("Error persisting laboratory tests.", he);
        }
        labTests.clear();
        labTests.addAll(retList);
    }
}

