/*
 * Decompiled with CFR 0.152.
 */
package gov.va.med.hds.hdr.service.dao.hibernate;

import gov.va.med.hds.hdr.common.datasource.DataSourceManager;
import gov.va.med.hds.hdr.service.Service;
import gov.va.med.hds.hdr.service.ServiceFactory;
import gov.va.med.hds.hdr.service.dao.DAOFactory;
import gov.va.med.hds.hdr.service.dao.DAOFactoryCreationException;
import gov.va.med.hds.hdr.service.dao.HL7AuditDAO;
import gov.va.med.hds.hdr.service.dao.LaboratoryDAO;
import gov.va.med.hds.hdr.service.dao.PatientDAO;
import gov.va.med.hds.hdr.service.dao.hibernate.HibernateLaboratoryDAO;
import java.util.Properties;
import org.hibernate.SessionFactory;

public class HibernateDAOFactory
implements ServiceFactory,
DAOFactory,
Service {
    private static final String SESSION_KEY = "FHIE.GOV/X0";
    private SessionFactory sessionFactory = null;

    public HibernateDAOFactory() throws DAOFactoryCreationException {
        try {
            this.sessionFactory = DataSourceManager.getInstance().getHibernateSessionFactory(SESSION_KEY);
        }
        catch (Exception e) {
            throw new DAOFactoryCreationException("An error occurred while getting the session factory from the DataSourceManager.", e);
        }
    }

    public PatientDAO createPatientDAO() {
        throw new UnsupportedOperationException("There is no hibernate impelementation of the patient data access object.");
    }

    public HL7AuditDAO createHL7AuditLogDAO() {
        throw new UnsupportedOperationException("There is no hibernate impelementation of the HL7 audit data access object.");
    }

    public LaboratoryDAO createLaboratoryDAO() {
        return new HibernateLaboratoryDAO(this.sessionFactory);
    }

    public Service createService(Properties properties) throws DAOFactoryCreationException {
        return new HibernateDAOFactory();
    }
}

